/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors;

import amazon.fws.clicommando.Command;
import amazon.fws.clicommando.config.ParamConfig;
import amazon.fws.clicommando.config.ValueReferenceConfig;
import amazon.fws.clicommando.exceptions.CliCommandoException;
import amazon.fws.clicommando.files.FileUtils;
import amazon.fws.clicommando.processors.CommandProcessor;
import amazon.fws.clicommando.util.StringUtils;
import java.util.Collection;

public class ReferenceLoaderCommandProcessor
implements CommandProcessor {
    public Command process(Command process) throws CliCommandoException {
        Collection<ParamConfig> parameters = process.getCurrentCommandConfig().getAllParameters();
        for (ParamConfig param : parameters) {
            ValueReferenceConfig vrf = param.getValueReferenceConfig();
            String paramValue = param.getValue();
            if (!this.isReference(param) || !StringUtils.notEmpty(paramValue) || !"file".equalsIgnoreCase(vrf.getType())) continue;
            String fileName = paramValue;
            String encoding = vrf.getArgument("encode");
            int maxSize = param.getMaxValueSize();
            param.setValue(FileUtils.readFileIntoString(fileName, encoding, maxSize));
        }
        return process;
    }

    private boolean isReference(ParamConfig paramConfig) {
        ValueReferenceConfig vrf = paramConfig.getValueReferenceConfig();
        return !"unknown".equals(vrf.getType());
    }
}

