#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Renowned Explorers
###

script_version=20230925.1

PLAYIT_COMPATIBILITY_LEVEL='2.26'

GAME_ID='renowned-explorers'
GAME_NAME='Renowned Explorers: International Society'

ARCHIVE_BASE_9_NAME='renowned_explorers_international_society_522_26056.sh'
ARCHIVE_BASE_9_MD5='fe38ae1c4dc2607923cc2a60019bff38'
ARCHIVE_BASE_9_SIZE='1200000'
ARCHIVE_BASE_9_VERSION='522-gog26056'
ARCHIVE_BASE_9_URL='https://www.gog.com/game/renowned_explorers'

ARCHIVE_BASE_8_NAME='renowned_explorers_international_society_520_25983.sh'
ARCHIVE_BASE_8_MD5='2af1dedb29ac1b929971cc0912722760'
ARCHIVE_BASE_8_SIZE='1200000'
ARCHIVE_BASE_8_VERSION='520-gog25983'

ARCHIVE_BASE_7_NAME='renowned_explorers_international_society_516_25864.sh'
ARCHIVE_BASE_7_MD5='d868d4b76613b93a94650b750a52752f'
ARCHIVE_BASE_7_SIZE='1200000'
ARCHIVE_BASE_7_VERSION='516-gog25864'

ARCHIVE_BASE_6_NAME='renowned_explorers_international_society_512_25169.sh'
ARCHIVE_BASE_6_MD5='3f2eb242da5200a78c53162d152a3cac'
ARCHIVE_BASE_6_SIZE='1100000'
ARCHIVE_BASE_6_VERSION='512-gog25169'

ARCHIVE_BASE_5_NAME='renowned_explorers_international_society_508_23701.sh'
ARCHIVE_BASE_5_MD5='247551613c7aba4b4b31f7a98fa31949'
ARCHIVE_BASE_5_SIZE='1100000'
ARCHIVE_BASE_5_VERSION='508-gog23701'

ARCHIVE_BASE_4_NAME='renowned_explorers_international_society_503_23529.sh'
ARCHIVE_BASE_4_MD5='6b7555749bc89cc3dda223e2d43bd838'
ARCHIVE_BASE_4_SIZE='1100000'
ARCHIVE_BASE_4_VERSION='503-gog23529'

ARCHIVE_BASE_3_NAME='renowned_explorers_international_society_en_489_21590.sh'
ARCHIVE_BASE_3_MD5='9fb2cbe095d437d788eb8ec6402db20b'
ARCHIVE_BASE_3_SIZE='1100000'
ARCHIVE_BASE_3_VERSION='489-gog21590'

ARCHIVE_BASE_2_NAME='renowned_explorers_international_society_en_489_20916.sh'
ARCHIVE_BASE_2_MD5='42d0ecb54d8302545e78f41ed43acef6'
ARCHIVE_BASE_2_SIZE='1100000'
ARCHIVE_BASE_2_VERSION='489-gog20916'

ARCHIVE_BASE_1_NAME='renowned_explorers_international_society_en_466_15616.sh'
ARCHIVE_BASE_1_MD5='fbad4b4d361a0e7d29b9781e3c5a5e85'
ARCHIVE_BASE_1_SIZE='1100000'
ARCHIVE_BASE_1_VERSION='466-gog15616'

ARCHIVE_BASE_0_NAME='renowned_explorers_international_society_en_459_14894.sh'
ARCHIVE_BASE_0_MD5='ff6b368b3919002d2db750213d33fcef'
ARCHIVE_BASE_0_SIZE='1100000'
ARCHIVE_BASE_0_VERSION='459-gog14894'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_LIBS_BIN32_PATH="${CONTENT_PATH_DEFAULT}/x86"
CONTENT_LIBS_BIN32_FILES='
libc++.so.1
libc++abi.so.1'
CONTENT_LIBS_BIN64_PATH="${CONTENT_PATH_DEFAULT}/x86_64"
CONTENT_LIBS_BIN64_FILES='
libc++.so.1
libc++abi.so.1'
CONTENT_GAME_BIN32_FILES='
x86/abbeycore'
CONTENT_GAME_BIN64_FILES='
x86_64/abbeycore'
CONTENT_GAME_DATA_FILES='
data
soundbanks
*.bni'

USER_PERSISTENT_DIRECTORIES='
userdata'

APP_MAIN_EXE_BIN32='x86/abbeycore'
APP_MAIN_EXE_BIN64='x86_64/abbeycore'
APP_MAIN_ICON='../support/icon.png'
## Work around inconsistent behaviour with some locales
APP_MAIN_PRERUN='# Work around inconsistent behaviour with some locales
export LANG=C
'

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN64_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN32_DEPS="$PKG_BIN_DEPS"
PKG_BIN64_DEPS="$PKG_BIN_DEPS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libGLU.so.1
libm.so.6
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libX11.so.6
libXcursor.so.1
libXrandr.so.2'
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Write launchers

PKG='PKG_BIN32'
launchers_write
PKG='PKG_BIN64'
launchers_write

# Build packages

packages_generation

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
