#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Warhammer 40k: Gladius expansions (units packs):
# - Reinforcement
# - Fortification
# - Specialist
# - Escalation
# - Firepower
###

script_version=20231222.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='warhammer-40k-gladius'
GAME_NAME='Warhammer 40,000: Gladius'

EXPANSION_ID_REINFORCEMENT='reinforcement-pack'
EXPANSION_NAME_REINFORCEMENT='Reinforcement Pack'

EXPANSION_ID_FORTIFICATION='fortification-pack'
EXPANSION_NAME_FORTIFICATION='Fortification Pack'

EXPANSION_ID_ASSAULT='assault-pack'
EXPANSION_NAME_ASSAULT='Assault Pack'

EXPANSION_ID_SPECIALIST='specialist-pack'
EXPANSION_NAME_SPECIALIST='Specialist Pack'

EXPANSION_ID_ESCALATION='escalation-pack'
EXPANSION_NAME_ESCALATION='Escalation Pack'

EXPANSION_ID_FIREPOWER='firepower-pack'
EXPANSION_NAME_FIREPOWER='Firepower Pack'

# Archives

## Reinforcement

ARCHIVE_BASE_REINFORCEMENT_17_NAME='warhammer_40_000_gladius_reinforcement_pack_1_13_02_69663.sh'
ARCHIVE_BASE_REINFORCEMENT_17_MD5='809e33306d041d5be456d1de728dc9ee'
ARCHIVE_BASE_REINFORCEMENT_17_SIZE='1086'
ARCHIVE_BASE_REINFORCEMENT_17_VERSION='1.13.2-gog69663'
ARCHIVE_BASE_REINFORCEMENT_17_URL='https://www.gog.com/game/warhammer_40000_gladius_reinforcement_pack'

ARCHIVE_BASE_REINFORCEMENT_16_NAME='warhammer_40_000_gladius_reinforcement_pack_1_13_01_69403.sh'
ARCHIVE_BASE_REINFORCEMENT_16_MD5='0c37c435320941b88a53f3ddc63381b6'
ARCHIVE_BASE_REINFORCEMENT_16_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENT_16_VERSION='1.13.1-gog69403'

ARCHIVE_BASE_REINFORCEMENT_15_NAME='warhammer_40_000_gladius_reinforcement_pack_1_12_03_67548.sh'
ARCHIVE_BASE_REINFORCEMENT_15_MD5='290f8f6e2a054d2fcc543318b3636063'
ARCHIVE_BASE_REINFORCEMENT_15_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENT_15_VERSION='1.12.3-gog67548'

ARCHIVE_BASE_REINFORCEMENT_12_NAME='warhammer_40_000_gladius_reinforcement_pack_1_11_04_64361.sh'
ARCHIVE_BASE_REINFORCEMENT_12_MD5='145f5a09d46543718f8bcc8b643f6807'
ARCHIVE_BASE_REINFORCEMENT_12_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENT_12_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_REINFORCEMENT_7_NAME='warhammer_40_000_gladius_reinforcement_pack_1_10_01_00_57375.sh'
ARCHIVE_BASE_REINFORCEMENT_7_MD5='59ac7359ac72a1f40f5ba237fcee8698'
ARCHIVE_BASE_REINFORCEMENT_7_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENT_7_VERSION='1.10.01-gog57375'

ARCHIVE_BASE_REINFORCEMENT_5_NAME='warhammer_40_000_gladius_reinforcement_pack_v1_09_03_00_54377.sh'
ARCHIVE_BASE_REINFORCEMENT_5_MD5='20cce6c9a3a012a4b2d3fda7101606f4'
ARCHIVE_BASE_REINFORCEMENT_5_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENT_5_VERSION='1.9.3.0-gog54377'

ARCHIVE_BASE_REINFORCEMENT_3_NAME='warhammer_40_000_gladius_reinforcement_pack_1_08_04_01_49548.sh'
ARCHIVE_BASE_REINFORCEMENT_3_MD5='72e9d71403328df72d4505096c98c423'
ARCHIVE_BASE_REINFORCEMENT_3_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENT_3_VERSION='1.8.4.1-gog49548'

ARCHIVE_BASE_REINFORCEMENT_0_NAME='warhammer_40_000_gladius_reinforcement_pack_1_07_04_44200.sh'
ARCHIVE_BASE_REINFORCEMENT_0_MD5='013e6db4458c5fe0c39b3a33bdda68e5'
ARCHIVE_BASE_REINFORCEMENT_0_SIZE='1400'
ARCHIVE_BASE_REINFORCEMENT_0_VERSION='1.7.4-gog44200'

## Fortification

ARCHIVE_BASE_FORTIFICATION_16_NAME='warhammer_40_000_gladius_fortification_pack_1_13_02_69663.sh'
ARCHIVE_BASE_FORTIFICATION_16_MD5='b316bde92f52a981ca432cbc1225a9d8'
ARCHIVE_BASE_FORTIFICATION_16_SIZE='1086'
ARCHIVE_BASE_FORTIFICATION_16_VERSION='1.13.2-gog69663'
ARCHIVE_BASE_FORTIFICATION_16_URL='https://www.gog.com/game/warhammer_40000_gladius_fortification_pack'

ARCHIVE_BASE_FORTIFICATION_15_NAME='warhammer_40_000_gladius_fortification_pack_1_13_01_69403.sh'
ARCHIVE_BASE_FORTIFICATION_15_MD5='a8a0af34a6e216ccb015a4dfc0c34543'
ARCHIVE_BASE_FORTIFICATION_15_SIZE='1400'
ARCHIVE_BASE_FORTIFICATION_15_VERSION='1.13.1-gog69403'

ARCHIVE_BASE_FORTIFICATION_14_NAME='warhammer_40_000_gladius_fortification_pack_1_12_03_67548.sh'
ARCHIVE_BASE_FORTIFICATION_14_MD5='32c26b39aaa8329f20bddccc4059a257'
ARCHIVE_BASE_FORTIFICATION_14_SIZE='1400'
ARCHIVE_BASE_FORTIFICATION_14_VERSION='1.12.3-gog67548'

ARCHIVE_BASE_FORTIFICATION_11_NAME='warhammer_40_000_gladius_fortification_pack_1_11_04_64361.sh'
ARCHIVE_BASE_FORTIFICATION_11_MD5='90d66263e66f30aa7c6df35ec2b0d276'
ARCHIVE_BASE_FORTIFICATION_11_SIZE='1400'
ARCHIVE_BASE_FORTIFICATION_11_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_FORTIFICATION_6_NAME='warhammer_40_000_gladius_fortification_pack_1_10_01_00_57375.sh'
ARCHIVE_BASE_FORTIFICATION_6_MD5='859c6d14d76a4b1a43880ea89e01ed27'
ARCHIVE_BASE_FORTIFICATION_6_SIZE='1400'
ARCHIVE_BASE_FORTIFICATION_6_VERSION='1.10.01-gog57375'

ARCHIVE_BASE_FORTIFICATION_4_NAME='warhammer_40_000_gladius_fortification_pack_v1_09_03_00_54377.sh'
ARCHIVE_BASE_FORTIFICATION_4_MD5='4221b279557e7af587ec6207f8654071'
ARCHIVE_BASE_FORTIFICATION_4_SIZE='1400'
ARCHIVE_BASE_FORTIFICATION_4_VERSION='1.9.3.0-gog54377'

ARCHIVE_BASE_FORTIFICATION_2_NAME='warhammer_40_000_gladius_fortification_pack_1_08_04_01_49548.sh'
ARCHIVE_BASE_FORTIFICATION_2_MD5='d485b048b4c1d391c7671ecc4c88e66d'
ARCHIVE_BASE_FORTIFICATION_2_SIZE='1400'
ARCHIVE_BASE_FORTIFICATION_2_VERSION='1.8.4.1-gog49548'

## Assault

ARCHIVE_BASE_ASSAULT_13_NAME='warhammer_40_000_gladius_assault_pack_1_13_02_69663.sh'
ARCHIVE_BASE_ASSAULT_13_MD5='69207a858cd17d53b696f23c9c481d67'
ARCHIVE_BASE_ASSAULT_13_SIZE='1086'
ARCHIVE_BASE_ASSAULT_13_VERSION='1.13.2-gog69663'
ARCHIVE_BASE_ASSAULT_13_URL='https://www.gog.com/game/warhammer_40000_gladius_assault_pack'

ARCHIVE_BASE_ASSAULT_12_NAME='warhammer_40_000_gladius_assault_pack_1_13_01_69403.sh'
ARCHIVE_BASE_ASSAULT_12_MD5='ca1484c5fba1a62eade6123c1baf4696'
ARCHIVE_BASE_ASSAULT_12_SIZE='1400'
ARCHIVE_BASE_ASSAULT_12_VERSION='1.13.1-gog69403'

ARCHIVE_BASE_ASSAULT_11_NAME='warhammer_40_000_gladius_assault_pack_1_12_03_67548.sh'
ARCHIVE_BASE_ASSAULT_11_MD5='9e56693f4d1623a9c7dcc9c2cf63a59a'
ARCHIVE_BASE_ASSAULT_11_SIZE='1400'
ARCHIVE_BASE_ASSAULT_11_VERSION='1.12.3-gog67548'

ARCHIVE_BASE_ASSAULT_8_NAME='warhammer_40_000_gladius_assault_pack_1_11_04_64361.sh'
ARCHIVE_BASE_ASSAULT_8_MD5='aae3f873d640d36f3821921efb7525c2'
ARCHIVE_BASE_ASSAULT_8_SIZE='1400'
ARCHIVE_BASE_ASSAULT_8_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_ASSAULT_3_NAME='warhammer_40_000_gladius_assault_pack_1_10_01_00_57375.sh'
ARCHIVE_BASE_ASSAULT_3_MD5='69d3d257e8caa70c7af8bd50b6963e0a'
ARCHIVE_BASE_ASSAULT_3_SIZE='1400'
ARCHIVE_BASE_ASSAULT_3_VERSION='1.10.01-gog57375'

ARCHIVE_BASE_ASSAULT_1_NAME='warhammer_40_000_gladius_assault_pack_v1_09_03_00_54377.sh'
ARCHIVE_BASE_ASSAULT_1_MD5='8812a45df8fa62523f655ecc2a1dbd46'
ARCHIVE_BASE_ASSAULT_1_SIZE='1400'
ARCHIVE_BASE_ASSAULT_1_VERSION='1.9.3.0-gog54377'

## Specialist

ARCHIVE_BASE_SPECIALIST_11_NAME='warhammer_40_000_gladius_specialist_pack_1_13_02_69663.sh'
ARCHIVE_BASE_SPECIALIST_11_MD5='01add4cdd855174cbc2c84043e0788d2'
ARCHIVE_BASE_SPECIALIST_11_SIZE='1086'
ARCHIVE_BASE_SPECIALIST_11_VERSION='1.13.2-gog69663'
ARCHIVE_BASE_SPECIALIST_11_URL='https://www.gog.com/game/warhammer_40000_gladius_specialist_pack'

ARCHIVE_BASE_SPECIALIST_10_NAME='warhammer_40_000_gladius_specialist_pack_1_13_01_69403.sh'
ARCHIVE_BASE_SPECIALIST_10_MD5='d84044d2586b22ca339f5089b61887ff'
ARCHIVE_BASE_SPECIALIST_10_SIZE='1400'
ARCHIVE_BASE_SPECIALIST_10_VERSION='1.13.1-gog69403'

ARCHIVE_BASE_SPECIALIST_9_NAME='warhammer_40_000_gladius_specialist_pack_1_12_03_67548.sh'
ARCHIVE_BASE_SPECIALIST_9_MD5='f8e1aaacc5a30496abae99c8a6965799'
ARCHIVE_BASE_SPECIALIST_9_SIZE='1400'
ARCHIVE_BASE_SPECIALIST_9_VERSION='1.12.3-gog67548'

ARCHIVE_BASE_SPECIALIST_6_NAME='warhammer_40_000_gladius_specialist_pack_1_11_04_64361.sh'
ARCHIVE_BASE_SPECIALIST_6_MD5='5f44ab4c03bf70047e6716000a29f910'
ARCHIVE_BASE_SPECIALIST_6_SIZE='1400'
ARCHIVE_BASE_SPECIALIST_6_VERSION='1.11.4-gog64361'

ARCHIVE_BASE_SPECIALIST_1_NAME='warhammer_40_000_gladius_specialist_pack_1_10_01_00_57375.sh'
ARCHIVE_BASE_SPECIALIST_1_MD5='b0b788d180a82919048621796f68fb1e'
ARCHIVE_BASE_SPECIALIST_1_SIZE='1400'
ARCHIVE_BASE_SPECIALIST_1_VERSION='1.10.01-gog57375'

## Escalation

ARCHIVE_BASE_ESCALATION_4_NAME='warhammer_40_000_gladius_escalation_pack_1_13_02_69663.sh'
ARCHIVE_BASE_ESCALATION_4_MD5='4f911c1846da28c4dd47aba3bacce026'
ARCHIVE_BASE_ESCALATION_4_SIZE='1086'
ARCHIVE_BASE_ESCALATION_4_VERSION='1.13.2-gog69663'
ARCHIVE_BASE_ESCALATION_4_URL='https://www.gog.com/game/warhammer_40000_gladius_adeptus_mechanicus'

ARCHIVE_BASE_ESCALATION_3_NAME='warhammer_40_000_gladius_escalation_pack_1_13_01_69403.sh'
ARCHIVE_BASE_ESCALATION_3_MD5='be161f47fcda7295c539f6930e480bd3'
ARCHIVE_BASE_ESCALATION_3_SIZE='1400'
ARCHIVE_BASE_ESCALATION_3_VERSION='1.13.1-gog69403'

ARCHIVE_BASE_ESCALATION_2_NAME='warhammer_40_000_gladius_escalation_pack_1_12_03_67548.sh'
ARCHIVE_BASE_ESCALATION_2_MD5='ce318c4cc0ee526f1abcd18ddbd4937c'
ARCHIVE_BASE_ESCALATION_2_SIZE='1400'
ARCHIVE_BASE_ESCALATION_2_VERSION='1.12.3-gog67548'

## Firepower

ARCHIVE_BASE_FIREPOWER_3_NAME='warhammer_40_000_gladius_firepower_pack_1_13_02_69663.sh'
ARCHIVE_BASE_FIREPOWER_3_MD5='81541c97a2f11295a9680538fe3860ec'
ARCHIVE_BASE_FIREPOWER_3_SIZE='1086'
ARCHIVE_BASE_FIREPOWER_3_VERSION='1.13.2-gog69663'
ARCHIVE_BASE_FIREPOWER_3_URL='https://www.gog.com/game/warhammer_40000_gladius_firepower_pack'

ARCHIVE_BASE_FIREPOWER_2_NAME='warhammer_40_000_gladius_firepower_pack_1_13_01_69403.sh'
ARCHIVE_BASE_FIREPOWER_2_MD5='772201eab8a7b882e5cba34ed55ec741'
ARCHIVE_BASE_FIREPOWER_2_SIZE='1400'
ARCHIVE_BASE_FIREPOWER_2_VERSION='1.13.1-gog69403'

ARCHIVE_BASE_FIREPOWER_1_NAME='warhammer_40_000_gladius_firepower_pack_1_12_03_67548.sh'
ARCHIVE_BASE_FIREPOWER_1_MD5='4f5adaaf42d40278df28bae531313c1d'
ARCHIVE_BASE_FIREPOWER_1_SIZE='1400'
ARCHIVE_BASE_FIREPOWER_1_VERSION='1.12.3-gog67548'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
Data/*.dlc'

PKG_MAIN_DEPS="$GAME_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
