/*---------------------------------------------------------------------------*\
 * Copyright (C) 2000 AVM GmbH. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE, and WITHOUT 
 * ANY LIABILITY FOR ANY DAMAGES arising out of or in connection 
 * with the use or performance of this software. See the
 * GNU General Public License for further details.
\*---------------------------------------------------------------------------*/

#ifndef _HUFMAN_H_
#define _HUFMAN_H_

/*=====================================================================*\
    Hufman tabels according to T30
\*=====================================================================*/
#define EOL 9999
#define TCLIM   64

/*---------------------------------------------------------------------*/
extern  INODE WhiteHUFS[];
INODE WhiteHUFS[] = {
    {   -1, {   1,   5 } },
    {   -1, {  21,   2 } },
    {   -1, {  25,   3 } },
    {   -1, {  50,   4 } },
    {    2, {   0,   0 } },
    {   -1, {   6,  11 } },
    {   -1, {   7,   9 } },
    {   -1, {   8,  17 } },
    {    3, {   0,   0 } },
    {   -1, {  19,  10 } },
    {    4, {   0,   0 } },
    {   -1, {  12,  14 } },
    {   -1, {  13,  28 } },
    {    5, {   0,   0 } },
    {   -1, {  15,  16 } },
    {    6, {   0,   0 } },
    {    7, {   0,   0 } },
    {   -1, {  30,  18 } },
    {    8, {   0,   0 } },
    {   -1, {  20,  44 } },
    {    9, {   0,   0 } },
    {   -1, {  31,  22 } },
    {   -1, {  35,  23 } },
    {   -1, {  78,  24 } },
    {   10, {   0,   0 } },
    {   -1, {  26,  47 } },
    {   -1, {  27,  53 } },
    {   11, {   0,   0 } },
    {   -1, {  41,  29 } },
    {   64, {   0,   0 } },
    {  128, {   0,   0 } },
    {   -1, {  38,  32 } },
    {   -1, {  58,  33 } },
    {   -1, {  56,  34 } },
    {    1, {   0,   0 } },
    {   -1, {  36,  61 } },
    {   -1, {  37,  74 } },
    {   12, {   0,   0 } },
    {   -1, {  64,  39 } },
    {   -1, {  67,  40 } },
    {   13, {   0,   0 } },
    {   -1, {  42,  43 } },
    {   14, {   0,   0 } },
    {   15, {   0,   0 } },
    {   -1, {  45,  46 } },
    {   16, {   0,   0 } },
    {   17, {   0,   0 } },
    {   -1, {  69,  48 } },
    {   -1, { 129,  49 } },
    {  192, {   0,   0 } },
    {   -1, {  51,  81 } },
    {   -1, {  52, 146 } },
    { 1664, {   0,   0 } },
    {   -1, {  76,  54 } },
    {   -1, { 175,  55 } },
    {   18, {   0,   0 } },
    {   -1, {  57,  91 } },
    {   19, {   0,   0 } },
    {   -1, {  59,  97 } },
    {   -1, {  60,  94 } },
    {   20, {   0,   0 } },
    {   -1, { 104,  62 } },
    {   -1, { 111,  63 } },
    {   21, {   0,   0 } },
    {   -1, {  87,  65 } },
    {   -1, { 114,  66 } },
    {   22, {   0,   0 } },
    {   -1, {  68, 117 } },
    {   23, {   0,   0 } },
    {   -1, {  70,  72 } },
    {   -1, {  71, 120 } },
    {   24, {   0,   0 } },
    {   -1, { 123,  73 } },
    {   25, {   0,   0 } },
    {   -1, { 126,  75 } },
    {   26, {   0,   0 } },
    {   -1, {  77, 136 } },
    {   27, {   0,   0 } },
    {   -1, {  79,  84 } },
    {   -1, {  80, 139 } },
    {   28, {   0,   0 } },
    {   -1, { 150,  82 } },
    {   -1, { 168,  83 } },
    {  256, {   0,   0 } },
    {   -1, {  85, 143 } },
    {   -1, { 142,  86 } },
    {    0, {   0,   0 } },
    {   -1, { 182,  88 } },
    {   -1, {  89,  90 } },
    {   29, {   0,   0 } },
    {   30, {   0,   0 } },
    {   -1, {  92,  93 } },
    {   31, {   0,   0 } },
    {   32, {   0,   0 } },
    {   -1, {  95,  96 } },
    {   33, {   0,   0 } },
    {   34, {   0,   0 } },
    {   -1, {  98, 101 } },
    {   -1, {  99, 100 } },
    {   35, {   0,   0 } },
    {   36, {   0,   0 } },
    {   -1, { 102, 103 } },
    {   37, {   0,   0 } },
    {   38, {   0,   0 } },
    {   -1, { 105, 108 } },
    {   -1, { 106, 107 } },
    {   39, {   0,   0 } },
    {   40, {   0,   0 } },
    {   -1, { 109, 110 } },
    {   41, {   0,   0 } },
    {   42, {   0,   0 } },
    {   -1, { 112, 113 } },
    {   43, {   0,   0 } },
    {   44, {   0,   0 } },
    {   -1, { 115, 116 } },
    {   45, {   0,   0 } },
    {   46, {   0,   0 } },
    {   -1, { 118, 119 } },
    {   47, {   0,   0 } },
    {   48, {   0,   0 } },
    {   -1, { 121, 122 } },
    {   49, {   0,   0 } },
    {   50, {   0,   0 } },
    {   -1, { 124, 125 } },
    {   51, {   0,   0 } },
    {   52, {   0,   0 } },
    {   -1, { 127, 128 } },
    {   53, {   0,   0 } },
    {   54, {   0,   0 } },
    {   -1, { 130, 133 } },
    {   -1, { 131, 132 } },
    {   55, {   0,   0 } },
    {   56, {   0,   0 } },
    {   -1, { 134, 135 } },
    {   57, {   0,   0 } },
    {   58, {   0,   0 } },
    {   -1, { 137, 138 } },
    {   59, {   0,   0 } },
    {   60, {   0,   0 } },
    {   -1, { 140, 141 } },
    {   61, {   0,   0 } },
    {   62, {   0,   0 } },
    {   63, {   0,   0 } },
    {   -1, { 144, 145 } },
    {  320, {   0,   0 } },
    {  384, {   0,   0 } },
    {   -1, { 147, 153 } },
    {   -1, { 148, 149 } },
    {  448, {   0,   0 } },
    {  512, {   0,   0 } },
    {   -1, { 151, 161 } },
    {   -1, { 152, 158 } },
    {  576, {   0,   0 } },
    {   -1, { 155, 154 } },
    {  640, {   0,   0 } },
    {   -1, { 156, 157 } },
    {  704, {   0,   0 } },
    {  768, {   0,   0 } },
    {   -1, { 159, 160 } },
    {  832, {   0,   0 } },
    {  896, {   0,   0 } },
    {   -1, { 162, 165 } },
    {   -1, { 163, 164 } },
    {  960, {   0,   0 } },
    { 1024, {   0,   0 } },
    {   -1, { 166, 167 } },
    { 1088, {   0,   0 } },
    { 1152, {   0,   0 } },
    {   -1, { 169, 172 } },
    {   -1, { 170, 171 } },
    { 1216, {   0,   0 } },
    { 1280, {   0,   0 } },
    {   -1, { 173, 174 } },
    { 1344, {   0,   0 } },
    { 1408, {   0,   0 } },
    {   -1, { 176, 179 } },
    {   -1, { 177, 178 } },
    { 1472, {   0,   0 } },
    { 1536, {   0,   0 } },
    {   -1, { 180, 181 } },
    { 1600, {   0,   0 } },
    { 1728, {   0,   0 } },
    {   -1, { 191, 183 } },
    {   -1, { 184, 187 } },
    {   -1, { 185, 198 } },
    {   -1, { 186, 195 } },
    { 1792, {   0,   0 } },
    {   -1, { 188, 205 } },
    {   -1, { 189, 190 } },
    { 1856, {   0,   0 } },
    { 1920, {   0,   0 } },
    {   -1, { 192,   0 } },
    {   -1, { 193,   0 } },
    {   -1, { 194,   0 } },
    { 9999, {   0,   0 } },
    {   -1, { 196, 197 } },
    { 1984, {   0,   0 } },
    { 2048, {   0,   0 } },
    {   -1, { 199, 202 } },
    {   -1, { 200, 201 } },
    { 2112, {   0,   0 } },
    { 2176, {   0,   0 } },
    {   -1, { 203, 204 } },
    { 2240, {   0,   0 } },
    { 2304, {   0,   0 } },
    {   -1, { 206, 209 } },
    {   -1, { 207, 208 } },
    { 2368, {   0,   0 } },
    { 2432, {   0,   0 } },
    {   -1, { 210, 211 } },
    { 2496, {   0,   0 } },
    { 2560, {   0,   0 } },
};

/*---------------------------------------------------------------------*/
extern  INODE BlackHUFS[];
INODE BlackHUFS[] = {
    {   -1, {   4,   1 } },
    {   -1, {   3,   2 } },
    {    2, {   0,   0 } },
    {    3, {   0,   0 } },
    {   -1, {   8,   5 } },
    {   -1, {   7,   6 } },
    {    4, {   0,   0 } },
    {    1, {   0,   0 } },
    {   -1, {  12,   9 } },
    {   -1, {  11,  10 } },
    {    5, {   0,   0 } },
    {    6, {   0,   0 } },
    {   -1, {  18,  13 } },
    {   -1, {  15,  14 } },
    {    7, {   0,   0 } },
    {   -1, {  17,  16 } },
    {    8, {   0,   0 } },
    {    9, {   0,   0 } },
    {   -1, {  25,  19 } },
    {   -1, {  20,  23 } },
    {   -1, {  21,  22 } },
    {   10, {   0,   0 } },
    {   11, {   0,   0 } },
    {   -1, {  31,  24 } },
    {   12, {   0,   0 } },
    {   -1, {  43,  26 } },
    {   -1, {  27,  29 } },
    {   -1, {  28,  37 } },
    {   13, {   0,   0 } },
    {   -1, {  40,  30 } },
    {   14, {   0,   0 } },
    {   -1, {  32,  34 } },
    {   -1, {  33,  51 } },
    {   15, {   0,   0 } },
    {   -1, {  54,  35 } },
    {   -1, {  57,  36 } },
    {    0, {   0,   0 } },
    {   -1, {  62,  38 } },
    {   -1, { 142,  39 } },
    {   16, {   0,   0 } },
    {   -1, {  41,  59 } },
    {   -1, {  42, 121 } },
    {   17, {   0,   0 } },
    {   -1, {  71,  44 } },
    {   -1, {  45,  48 } },
    {   -1, {  46,  65 } },
    {   -1, {  47, 128 } },
    {   18, {   0,   0 } },
    {   -1, {  68,  49 } },
    {   -1, { 134,  50 } },
    {   64, {   0,   0 } },
    {   -1, {  84,  52 } },
    {   -1, {  88,  53 } },
    {   19, {   0,   0 } },
    {   -1, {  55, 101 } },
    {   -1, {  56,  98 } },
    {   20, {   0,   0 } },
    {   -1, {  58, 111 } },
    {   21, {   0,   0 } },
    {   -1, {  91,  60 } },
    {   -1, { 108,  61 } },
    {   22, {   0,   0 } },
    {   -1, {  63, 114 } },
    {   -1, {  64, 125 } },
    {   23, {   0,   0 } },
    {   -1, { 139,  66 } },
    {   -1, { 148,  67 } },
    {   24, {   0,   0 } },
    {   -1, {  69, 131 } },
    {   -1, {  70, 159 } },
    {   25, {   0,   0 } },
    {   -1, {  80,  72 } },
    {   -1, {  73,  76 } },
    {   -1, {  74, 167 } },
    {   -1, {  75, 164 } },
    { 1792, {   0,   0 } },
    {   -1, {  77, 174 } },
    {   -1, {  78,  79 } },
    { 1856, {   0,   0 } },
    { 1920, {   0,   0 } },
    {   -1, {  81,   0 } },
    {   -1, {  82,   0 } },
    {   -1, {  83,   0 } },
    { 9999, {   0,   0 } },
    {   -1, { 155,  85 } },
    {   -1, {  86,  87 } },
    {   26, {   0,   0 } },
    {   27, {   0,   0 } },
    {   -1, {  89,  90 } },
    {   28, {   0,   0 } },
    {   29, {   0,   0 } },
    {   -1, {  92,  95 } },
    {   -1, {  93,  94 } },
    {   30, {   0,   0 } },
    {   31, {   0,   0 } },
    {   -1, {  96,  97 } },
    {   32, {   0,   0 } },
    {   33, {   0,   0 } },
    {   -1, {  99, 100 } },
    {   34, {   0,   0 } },
    {   35, {   0,   0 } },
    {   -1, { 102, 105 } },
    {   -1, { 103, 104 } },
    {   36, {   0,   0 } },
    {   37, {   0,   0 } },
    {   -1, { 106, 107 } },
    {   38, {   0,   0 } },
    {   39, {   0,   0 } },
    {   -1, { 109, 110 } },
    {   40, {   0,   0 } },
    {   41, {   0,   0 } },
    {   -1, { 112, 113 } },
    {   42, {   0,   0 } },
    {   43, {   0,   0 } },
    {   -1, { 115, 118 } },
    {   -1, { 116, 117 } },
    {   44, {   0,   0 } },
    {   45, {   0,   0 } },
    {   -1, { 119, 120 } },
    {   46, {   0,   0 } },
    {   47, {   0,   0 } },
    {   -1, { 122, 152 } },
    {   -1, { 123, 124 } },
    {   48, {   0,   0 } },
    {   49, {   0,   0 } },
    {   -1, { 126, 127 } },
    {   50, {   0,   0 } },
    {   51, {   0,   0 } },
    {   -1, { 129, 137 } },
    {   -1, { 130, 184 } },
    {   52, {   0,   0 } },
    {   -1, { 161, 132 } },
    {   -1, { 181, 133 } },
    {   53, {   0,   0 } },
    {   -1, { 135, 193 } },
    {   -1, { 136, 190 } },
    {   54, {   0,   0 } },
    {   -1, { 187, 138 } },
    {   55, {   0,   0 } },
    {   -1, { 140, 146 } },
    {   -1, { 141, 200 } },
    {   56, {   0,   0 } },
    {   -1, { 143, 150 } },
    {   -1, { 144, 145 } },
    {   57, {   0,   0 } },
    {   58, {   0,   0 } },
    {   -1, { 203, 147 } },
    {   59, {   0,   0 } },
    {   -1, { 149, 206 } },
    {   60, {   0,   0 } },
    {   -1, { 151, 158 } },
    {   61, {   0,   0 } },
    {   -1, { 153, 154 } },
    {   62, {   0,   0 } },
    {   63, {   0,   0 } },
    {   -1, { 156, 157 } },
    {  128, {   0,   0 } },
    {  192, {   0,   0 } },
    {  256, {   0,   0 } },
    {   -1, { 209, 160 } },
    {  320, {   0,   0 } },
    {   -1, { 162, 163 } },
    {  384, {   0,   0 } },
    {  448, {   0,   0 } },
    {   -1, { 165, 166 } },
    { 1984, {   0,   0 } },
    { 2048, {   0,   0 } },
    {   -1, { 168, 171 } },
    {   -1, { 169, 170 } },
    { 2112, {   0,   0 } },
    { 2176, {   0,   0 } },
    {   -1, { 172, 173 } },
    { 2240, {   0,   0 } },
    { 2304, {   0,   0 } },
    {   -1, { 175, 178 } },
    {   -1, { 176, 177 } },
    { 2368, {   0,   0 } },
    { 2432, {   0,   0 } },
    {   -1, { 179, 180 } },
    { 2496, {   0,   0 } },
    { 2560, {   0,   0 } },
    {   -1, { 182, 183 } },
    {  512, {   0,   0 } },
    {  576, {   0,   0 } },
    {   -1, { 185, 186 } },
    {  640, {   0,   0 } },
    {  704, {   0,   0 } },
    {   -1, { 188, 189 } },
    {  768, {   0,   0 } },
    {  832, {   0,   0 } },
    {   -1, { 191, 192 } },
    {  896, {   0,   0 } },
    {  960, {   0,   0 } },
    {   -1, { 194, 197 } },
    {   -1, { 195, 196 } },
    { 1024, {   0,   0 } },
    { 1088, {   0,   0 } },
    {   -1, { 198, 199 } },
    { 1152, {   0,   0 } },
    { 1216, {   0,   0 } },
    {   -1, { 201, 202 } },
    { 1280, {   0,   0 } },
    { 1344, {   0,   0 } },
    {   -1, { 204, 205 } },
    { 1408, {   0,   0 } },
    { 1472, {   0,   0 } },
    {   -1, { 207, 208 } },
    { 1536, {   0,   0 } },
    { 1600, {   0,   0 } },
    {   -1, { 210, 211 } },
    { 1664, {   0,   0 } },
    { 1728, {   0,   0 } },
};

#endif

