/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#ifndef FRAG_RULE_HPP
#define FRAG_RULE_HPP


/////////////////////// Qt includes
#include <QString>


/////////////////////// Local includes
#include "exportimportconfig.h"
#include "PolChemDefEntity.hpp"
#include "Formula.hpp"
#include "Monomer.hpp"


namespace MsXpS
{


namespace libXpertMass
{


class DECLSPEC FragRule : public PolChemDefEntity, public Formula
{
  public:
  FragRule(PolChemDefCstSPtr,
           QString,
           QString         = QString(),
           QString         = QString(),
           QString         = QString(),
           QString         = QString(),
           const QString & = QString());

  FragRule(const FragRule &other);
  ~FragRule();

  using PolChemDefEntity::operator=;
  using Formula::operator=;
  FragRule &operator=(const FragRule &other);

  void setPrevCode(const QString &);
  QString prevCode() const;

  void setCurrCode(const QString &);
  QString currCode() const;

  void setNextCode(const QString &);
  QString nextCode() const;

  QString formula() const;

  void setComment(const QString &);
  QString comment() const;

  static int isNameInList(const QString &,
                          const QList<FragRule *> &,
                          FragRule *other = nullptr);

  using Formula::validate;
  using PolChemDefEntity::validate;
  bool validate();

  bool renderXmlFgrElement(const QDomElement &);

  QString *formatXmlFgrElement(int, const QString & = QString("  "));

  protected:
  QString m_prevCode;
  QString m_currCode;
  QString m_nextCode;
  QString m_comment;
};

} // namespace libXpertMass

} // namespace MsXpS


#endif // FRAG_RULE_HPP
