/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


/////////////////////// Qt includes
#include <QMainWindow>
#include <QDir>
#include <QStringList>


/////////////////////// pappsomspp includes

/////////////////////// libXpertMassCore includes
#include <MsXpS/libXpertMassCore/PolChemDef.hpp>
#include <MsXpS/libXpertMassCore/PolChemDefSpec.hpp>
#include <MsXpS/libXpertMassCore/MassDataServer.hpp>
#include <MsXpS/libXpertMassCore/MassDataClient.hpp>


/////////////////////// libXpertMassGUI includes
#include <MsXpS/libXpertMassGui/MassDataClientServerConfigDlg.hpp>
#include <MsXpS/libXpertMassGui/IsotopicClusterGeneratorDlg.hpp>
#include <MsXpS/libXpertMassGui/IsotopicClusterShaperDlg.hpp>


/////////////////////// local includes
#include "MsXpS/libXpertMassGui/JavaScriptWorker.hpp"
#include "MsXpS/libXpertMassGui/JavaScriptingEnvironment.hpp"
#include "MsXpS/libXpertMassGui/JavaScriptingWnd.hpp"


namespace MsXpS
{
namespace libXpertMassGui
{

JavaScriptWorker::JavaScriptWorker(QString script,
                                   const JavaScriptingEnvironment *env)
  : m_script(script), mp_scriptingEnvironment(env)
{
}

void
JavaScriptWorker::run()
{
  mp_scriptingEnvironment->initializeJsEngine();

  QJSValue value = mp_scriptingEnvironment->getJsEngine()->evaluate(m_script);

  emit finishedSignal(value);
}

void
JavaScriptWorker::requestAbort()
{
  // qDebug() << "Abort was requested.";

  mp_scriptingEnvironment->getJsEngine()->globalObject().setProperty(
    "__abortRequested", QJSValue(true));
}


} // namespace libXpertMassGui
} // namespace MsXpS
