// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BOPTools_AlgoTools2D_HeaderFile
#define _BOPTools_AlgoTools2D_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _BOPCol_ListOfShape_HeaderFile
#include <BOPCol_ListOfShape.hxx>
#endif
class TopoDS_Edge;
class TopoDS_Face;
class gp_Vec;
class Geom2d_Curve;
class Geom_Curve;
class ProjLib_ProjectedCurve;



//!  The class contains handy static functions <br>
//!  dealing with the topology <br>
//!  This is the copy of the BOPTools_AlgoTools2D.cdl <br>
class BOPTools_AlgoTools2D  {
public:

  DEFINE_STANDARD_ALLOC

  
//! Compute P-Curve for the edge <aE> on the face <aF> <br>
//! <br>
  Standard_EXPORT   static  void BuildPCurveForEdgeOnFace(const TopoDS_Edge& aE,const TopoDS_Face& aF) ;
  
//! Compute tangent for the edge  <aE> [in 3D]  at parameter <aT> <br>
//! <br>
  Standard_EXPORT   static  Standard_Boolean EdgeTangent(const TopoDS_Edge& anE,const Standard_Real aT,gp_Vec& Tau) ;
  
//! Compute surface parameters <U,V> of the face <aF> <br>
//! for  the point from the edge <aE> at parameter <aT>. <br>
//! <br>
  Standard_EXPORT   static  void PointOnSurface(const TopoDS_Edge& aE,const TopoDS_Face& aF,const Standard_Real aT,Standard_Real& U,Standard_Real& V) ;
  
//! Get P-Curve <aC>  for the edge <aE> on surface <aF> . <br>
//! If the P-Curve does not exist, build  it using Make2D(). <br>
//! [aToler] - reached tolerance <br>
//! <br>
  Standard_EXPORT   static  void CurveOnSurface(const TopoDS_Edge& aE,const TopoDS_Face& aF,Handle(Geom2d_Curve)& aC,Standard_Real& aToler) ;
  
//! Get P-Curve <aC>  for the edge <aE> on surface <aF> . <br>
//! If the P-Curve does not exist, build  it using Make2D(). <br>
//! [aFirst, aLast] - range of the P-Curve <br>
//! [aToler] - reached tolerance <br>
//! <br>
  Standard_EXPORT   static  void CurveOnSurface(const TopoDS_Edge& aE,const TopoDS_Face& aF,Handle(Geom2d_Curve)& aC,Standard_Real& aFirst,Standard_Real& aLast,Standard_Real& aToler) ;
  
//! Returns TRUE if the edge <aE>  has  P-Curve <aC> <br>
//! on surface <aF> . <br>
//! [aFirst, aLast] - range of the P-Curve <br>
//! [aToler] - reached tolerance <br>
//! If the P-Curve does not exist, aC.IsNull()=TRUE. <br>
//! <br>
  Standard_EXPORT   static  Standard_Boolean HasCurveOnSurface(const TopoDS_Edge& aE,const TopoDS_Face& aF,Handle(Geom2d_Curve)& aC,Standard_Real& aFirst,Standard_Real& aLast,Standard_Real& aToler) ;
  
//! Returns TRUE if the edge <aE>  has  P-Curve <aC> <br>
//! on surface <aF> . <br>
//! If the P-Curve does not exist, aC.IsNull()=TRUE. <br>
//! <br>
  Standard_EXPORT   static  Standard_Boolean HasCurveOnSurface(const TopoDS_Edge& aE,const TopoDS_Face& aF) ;
  
//! Adjust P-Curve <aC2D> (3D-curve <C3D>) on surface <aF> . <br>
//! <br>
  Standard_EXPORT   static  void AdjustPCurveOnFace(const TopoDS_Face& aF,const Handle(Geom_Curve)& C3D,const Handle(Geom2d_Curve)& aC2D,Handle(Geom2d_Curve)& aC2DA) ;
  
//! Adjust P-Curve <aC2D> (3D-curve <C3D>) on surface <aF> . <br>
//! [aT1,  aT2] - range to adjust <br>
//! <br>
  Standard_EXPORT   static  void AdjustPCurveOnFace(const TopoDS_Face& aF,const Standard_Real aT1,const Standard_Real aT2,const Handle(Geom2d_Curve)& aC2D,Handle(Geom2d_Curve)& aC2DA) ;
  
//! Compute intermediate  value in  between [aFirst, aLast] . <br>
//! <br>
  Standard_EXPORT   static  Standard_Real IntermediatePoint(const Standard_Real aFirst,const Standard_Real aLast) ;
  
//! Compute intermediate value of parameter for the edge <anE>. <br>
//! <br>
  Standard_EXPORT   static  Standard_Real IntermediatePoint(const TopoDS_Edge& anE) ;
  
  Standard_EXPORT   static  void BuildPCurveForEdgeOnPlane(const TopoDS_Edge& theE,const TopoDS_Face& theF) ;
  
  Standard_EXPORT   static  void BuildPCurveForEdgesOnPlane(const BOPCol_ListOfShape& theLE,const TopoDS_Face& theF) ;
  
//! Make P-Curve <aC> for the edge <aE> on surface <aF> . <br>
//! [aFirst, aLast] - range of the P-Curve <br>
//! [aToler] - reached tolerance <br>
//! <br>
  Standard_EXPORT   static  void Make2D(const TopoDS_Edge& aE,const TopoDS_Face& aF,Handle(Geom2d_Curve)& aC,Standard_Real& aFirst,Standard_Real& aLast,Standard_Real& aToler) ;
  
//! Same  as   Make2D() <br>
//! <br>
  Standard_EXPORT   static  void MakeCurveOnSurface(const TopoDS_Edge& aE,const TopoDS_Face& aF,Handle(Geom2d_Curve)& aC,Standard_Real& aFirst,Standard_Real& aLast,Standard_Real& aToler) ;
  
//! Make P-Curve <aC> for the 3D-curve <C3D> on surface <aF> . <br>
//! [aToler] - reached tolerance <br>
//! <br>
  Standard_EXPORT   static  void MakePCurveOnFace(const TopoDS_Face& aF,const Handle(Geom_Curve)& C3D,Handle(Geom2d_Curve)& aC,Standard_Real& aToler) ;
  
//! Make P-Curve <aC> for the 3D-curve <C3D> on surface <aF> . <br>
//! [aT1,  aT2] - range to build <br>
//! [aToler] - reached tolerance <br>
//! <br>
  Standard_EXPORT   static  void MakePCurveOnFace(const TopoDS_Face& aF,const Handle(Geom_Curve)& C3D,const Standard_Real aT1,const Standard_Real aT2,Handle(Geom2d_Curve)& aC,Standard_Real& aToler) ;
  
//! Make empty  P-Curve <aC> of relevant to <PC> type <br>
//! <br>
  Standard_EXPORT   static  void MakePCurveOfType(const ProjLib_ProjectedCurve& PC,Handle(Geom2d_Curve)& aC) ;





protected:





private:





};





// other Inline functions and methods (like "C++: function call" methods)


#endif
