Contributing to QMix 
====================

We welcome contributions via [pull requests](#contributing-new-code). You can also [report bugs](#reporting-bugs) or [request new features](#requesting-new-features) through the [GitHub issue tracker](https://github.com/garrettj403/QMix/issues).

**Note:** If you are new to GitHub, you can learn more about how to make contributions to GitHub projects [here](https://guides.github.com/introduction/flow/) and more about forking repositories [here](https://guides.github.com/activities/forking/).

Reporting Bugs 
--------------

If you find any bugs in QMix, please create a new issue through the [GitHub Issue tracker](https://github.com/garrettj403/QMix/issues) with the ``bug`` label. In your message, please include your:
   - operating system
   - Python version
   - package versions (Numpy, SciPy and Matplotlib)
   - if applicable, a small code snippet that recreates the error

**Note:** Before reporting a bug, please ensure that you are using the latest version of QMix and that you are using the QMix virtual environment (``QMix/environment.yml``).

Requesting New Features
-----------------------

If you would like a new feature added to QMix, please create a new issue through the [GitHub Issue tracker](https://github.com/garrettj403/QMix/issues) with the ``enhancement`` label. We can then discuss the improvements online, including whether the changes are necessary and how to implement the proposed changes.

Contributing New Code
---------------------

If you would like to contribute new code to the QMix project, you can fork the repository, make your changes, and then create a pull request. To remain consistent with the rest of the QMix package, please follow the [QMix code guidelines](https://github.com/garrettj403/QMix/blob/master/CODE_GUIDELINES.md).

Seeking Support
---------------

If you are having any problems installing QMix or setting up your simulation, please create a new issue through the [GitHub Issue tracker](https://github.com/garrettj403/QMix/issues) with the ``help wanted`` or ``question`` tag.  In your message, please include your:
   - operating system
   - Python version
   - package versions (Numpy, SciPy and Matplotlib)

