% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caret-package.R
\docType{data}
\name{mdrr}
\alias{mdrr}
\alias{mdrrClass}
\alias{mdrrDescr}
\title{Multidrug Resistance Reversal (MDRR) Agent Data}
\source{
Svetnik, V., Liaw, A., Tong, C., Culberson, J. C., Sheridan, R. P.
Feuston, B. P (2003).  Random Forest: A Classification and Regression Tool
for Compound Classification and QSAR Modeling, \emph{Journal of Chemical
Information and Computer Sciences}, Vol. 43, pg. 1947-1958.
}
\value{
\item{mdrrDescr}{the descriptors} \item{mdrrClass}{the categorical
outcome ("Active" or "Inactive")}
}
\description{
Svetnik et al. (2003) describe these data: "Bakken and Jurs studied a set of
compounds originally discussed by Klopman et al., who were interested in
multidrug resistance reversal (MDRR) agents. The original response variable
is a ratio measuring the ability of a compound to reverse a leukemia cell's
resistance to adriamycin. However, the problem was treated as a
classification problem, and compounds with the ratio >4.2 were considered
active, and those with the ratio <= 2.0 were considered inactive. Compounds
with the ratio between these two cutoffs were called moderate and removed
from the data for twoclass classification, leaving a set of 528 compounds
(298 actives and 230 inactives). (Various other arrangements of these data
were examined by Bakken and Jurs, but we will focus on this particular one.)
We did not have access to the original descriptors, but we generated a set
of 342 descriptors of three different types that should be similar to the
original descriptors, using the DRAGON software."
}
\details{
The data and R code are in the Supplemental Data file for the article.
}
\keyword{datasets}
