% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-arrow-read-table-arrow.R
\docType{data}
\name{spec_arrow_read_table_arrow}
\alias{spec_arrow_read_table_arrow}
\title{spec_arrow_read_table_arrow}
\value{
\code{dbReadTableArrow()} returns a data frame that contains the complete data
from the remote table, effectively the result of calling \code{\link[=dbGetQuery]{dbGetQuery()}}
with \verb{SELECT * FROM <name>}.

An empty table is returned as a data frame with zero rows.
}
\description{
spec_arrow_read_table_arrow
}
\section{Failure modes}{

An error is raised if the table does not exist.


An error is raised when calling this method for a closed
or invalid connection.
An error is raised
if \code{name} cannot be processed with \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}
or if this results in a non-scalar.
}

\section{Specification}{

The \code{name} argument is processed as follows,
to support databases that allow non-syntactic names for their objects:
\itemize{
\item If an unquoted table name as string: \code{dbReadTableArrow()} will do the
quoting,
perhaps by calling \code{dbQuoteIdentifier(conn, x = name)}
\item If the result of a call to \code{\link[=dbQuoteIdentifier]{dbQuoteIdentifier()}}: no more quoting is done
}
}

\seealso{
Other Arrow specifications: 
\code{\link{spec_arrow_append_table_arrow}},
\code{\link{spec_arrow_create_table_arrow}},
\code{\link{spec_arrow_fetch_arrow_chunk}},
\code{\link{spec_arrow_fetch_arrow}},
\code{\link{spec_arrow_get_query_arrow}},
\code{\link{spec_arrow_send_query_arrow}},
\code{\link{spec_arrow_write_table_arrow}},
\code{\link{spec_result_clear_result}}
}
\concept{Arrow specifications}
