% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.R
\name{fct_na_value_to_level}
\alias{fct_na_value_to_level}
\alias{fct_na_level_to_value}
\title{Convert between \code{NA} values and \code{NA} levels}
\usage{
fct_na_value_to_level(f, level = NA)

fct_na_level_to_value(f, extra_levels = NULL)
}
\arguments{
\item{f}{A factor (or character vector).}

\item{level}{Optionally, instead of converting the \code{NA} values to an
\code{NA} level, convert it to a level with this value.}

\item{extra_levels}{Optionally, a character vector giving additional levels
that should also be converted to \code{NA} values.}
}
\description{
There are two ways to represent missing values in factors: in the values
and in the levels. \code{NA}s in the values are most useful for data analysis
(since \code{\link[=is.na]{is.na()}} returns what you expect), but because the \code{NA} is not
explicitly recorded in the levels, there's no way to control its position
(it's almost always displayed last or not at all). Putting the \code{NA}s in the levels allows
you to control its display, at the cost of losing accurate \code{is.na()}
reporting.

(It is possible to have a factor with missing values in both the values
and the levels but it requires some explicit gymnastics and we don't
recommend it.)
}
\examples{
# Most factors store NAs in the values:
f1 <- fct(c("a", "b", NA, "c", "b", NA))
levels(f1)
as.integer(f1)
is.na(f1)

# But it's also possible to store them in the levels
f2 <- fct_na_value_to_level(f1)
levels(f2)
as.integer(f2)
is.na(f2)

# If needed, you can convert back to NAs in the values:
f3 <- fct_na_level_to_value(f2)
levels(f3)
as.integer(f3)
is.na(f3)
}
