% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.R
\name{raster_str}
\alias{raster_str}
\alias{raster_view}
\title{Draw/preview a raster into a string}
\usage{
raster_str(x, width = 480, height = 480, interpolate = FALSE)

raster_view(code)
}
\arguments{
\item{x}{A raster object}

\item{width, height}{Width and height in pixels.}

\item{interpolate}{A logical value indicating whether to linearly
interpolate the image.}

\item{code}{base64 code of a raster}
}
\description{
\code{raster_view} is a helper function for testing. It uses \code{htmltools}
to render a png as an image with base64 encoded data image.
}
\examples{
r <- as.raster(matrix(hcl(0, 80, seq(50, 80, 10)),
 nrow = 4, ncol = 5))
code <- raster_str(r, width = 50, height = 50)
if (interactive() && require("htmltools")) {
  raster_view(code = code)
}
}
