% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setWindowSize.R
\name{setWindowSize}
\alias{setWindowSize}
\alias{getWindowSize}
\title{Set and Get Window Size for xlsx file}
\usage{
setWindowSize(
  wb,
  xWindow = NULL,
  yWindow = NULL,
  windowWidth = NULL,
  windowHeight = NULL
)

getWindowSize(wb)
}
\arguments{
\item{wb}{A Workbook object}

\item{xWindow}{the horizontal coordinate of the top left corner of the window}

\item{yWindow}{the vertical coordinate of the top left corner of the window}

\item{windowWidth}{the width of the window}

\item{windowHeight}{the height of the window

Set the size and position of the window when you open the xlsx file.  The units are in twips.  See
\href{https://learn.microsoft.com/en-us/dotnet/api/documentformat.openxml.spreadsheet.workbookview?view=openxml-2.8.1}{Microsoft's documentation for the xlsx standard}}
}
\description{
Set and Get Window Size for xlsx file
}
\examples{
## Create Workbook object and add worksheets
wb <- createWorkbook()
addWorksheet(wb, "S1")
getWindowSize(wb)
setWindowSize(wb, windowWidth = 10000)
}
