% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_scope.R
\name{find_scope}
\alias{find_scope}
\title{Find the default scope of a call.}
\usage{
find_scope(frame = NULL, global = FALSE)
}
\arguments{
\item{frame}{The frame to infer scope from.}

\item{global}{Should the global frame be listed in the scope.}
}
\description{
This find the scope of the call.
It includes the package of the call,
the class if called from a method,
and the name of the function called.
}
\examples{

my_function <- function(){
    scope <- find_scope()
    "You are in" \%<<\% collapse(scope, '::')
}
my_function()

my_sights <- my_function
my_sights()

}
