// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UADDL_2D_TRACE_AARCH64_H_
#define VIXL_SIM_UADDL_2D_TRACE_AARCH64_H_

const uint64_t kExpected_NEON_uaddl_2D[] = {
  0x000000000000fc00, 0x000000000000fe00,
  0x000000000000fd00, 0x0000000000807c00,
  0x0000000000807b00, 0x0000000000007f00,
  0x0000000000007e00, 0x0000000000007f01,
  0x0000000000007e01, 0x0000000000007f02,
  0x0000000000007e02, 0x0000000000007f20,
  0x0000000000007e20, 0x0000000000007f7d,
  0x0000000000007e7d, 0x0000000000007f7e,
  0x0000000000007e7e, 0x0000000000007f7f,
  0x0000000000007e7f, 0x000000000000fefd,
  0x000000000000fdfd, 0x000000000000fefe,
  0x000000000000fdfe, 0x000000000000feff,
  0x000000000000fdff, 0x000000003333b233,
  0x000000003333b133, 0x000000005555d455,
  0x000000005555d355, 0x0000000080007efd,
  0x0000000080007dfd, 0x0000000080007efe,
  0x0000000080007dfe, 0x0000000080007eff,
  0x0000000080007dff, 0x0000000080007f00,
  0x0000000080007e00, 0x0000000080007f01,
  0x0000000080007e01, 0x00000000aaab29aa,
  0x00000000aaab28aa, 0x00000000cccd4bcc,
  0x00000000cccd4acc, 0x00000000ffffff00,
  0x00000000fffffe00, 0x00000000ffffff01,
  0x00000000fffffe01, 0x00000000ffffff02,
  0x00000000fffffe02, 0x00000000ffffff03,
  0x00000000fffffe03, 0x0000000100007e80,
  0x0000000100007d80, 0x0000000100007e81,
  0x0000000100007d81, 0x0000000100007e82,
  0x0000000100007d82, 0x0000000100007e83,
  0x0000000100007d83, 0x0000000100007ee0,
  0x0000000100007de0, 0x0000000100007efd,
  0x0000000100007efd, 0x00000001007ffcfe,
  0x0000000100007efe, 0x00000001007ffcff,
  0x0000000100007eff, 0x00000000007ffd00,
  0x0000000000007f00, 0x00000000007ffd01,
  0x0000000000007f01, 0x00000000007ffd02,
  0x0000000000007f02, 0x00000000007ffd20,
  0x0000000000007f20, 0x00000000007ffd7d,
  0x0000000000007f7d, 0x00000000007ffd7e,
  0x0000000000007f7e, 0x00000000007ffd7f,
  0x0000000000007f7f, 0x0000000000807cfd,
  0x000000000000fefd, 0x0000000000807cfe,
  0x000000000000fefe, 0x0000000000807cff,
  0x000000000000feff, 0x0000000033b33033,
  0x000000003333b233, 0x0000000055d55255,
  0x000000005555d455, 0x00000000807ffcfd,
  0x0000000080007efd, 0x00000000807ffcfe,
  0x0000000080007efe, 0x00000000807ffcff,
  0x0000000080007eff, 0x00000000807ffd00,
  0x0000000080007f00, 0x00000000807ffd01,
  0x0000000080007f01, 0x00000000ab2aa7aa,
  0x00000000aaab29aa, 0x00000000cd4cc9cc,
  0x00000000cccd4bcc, 0x00000001007f7d00,
  0x00000000ffffff00, 0x00000001007f7d01,
  0x00000000ffffff01, 0x00000001007f7d02,
  0x00000000ffffff02, 0x00000001007f7d03,
  0x00000000ffffff03, 0x00000001007ffc80,
  0x0000000100007e80, 0x00000001007ffc81,
  0x0000000100007e81, 0x00000001007ffc82,
  0x0000000100007e82, 0x00000001007ffc83,
  0x0000000100007e83, 0x00000001007ffce0,
  0x0000000100007ee0, 0x00000001007ffcfd,
  0x00000001007ffcfd, 0x00000000fffffffe,
  0x00000001007ffcfe, 0x00000000ffffffff,
  0x00000001007ffcff, 0x0000000000000000,
  0x00000000007ffd00, 0x0000000000000001,
  0x00000000007ffd01, 0x0000000000000002,
  0x00000000007ffd02, 0x0000000000000020,
  0x00000000007ffd20, 0x000000000000007d,
  0x00000000007ffd7d, 0x000000000000007e,
  0x00000000007ffd7e, 0x000000000000007f,
  0x00000000007ffd7f, 0x0000000000007ffd,
  0x0000000000807cfd, 0x0000000000007ffe,
  0x0000000000807cfe, 0x0000000000007fff,
  0x0000000000807cff, 0x0000000033333333,
  0x0000000033b33033, 0x0000000055555555,
  0x0000000055d55255, 0x000000007ffffffd,
  0x00000000807ffcfd, 0x000000007ffffffe,
  0x00000000807ffcfe, 0x000000007fffffff,
  0x00000000807ffcff, 0x0000000080000000,
  0x00000000807ffd00, 0x0000000080000001,
  0x00000000807ffd01, 0x00000000aaaaaaaa,
  0x00000000ab2aa7aa, 0x00000000cccccccc,
  0x00000000cd4cc9cc, 0x00000000ffff8000,
  0x00000001007f7d00, 0x00000000ffff8001,
  0x00000001007f7d01, 0x00000000ffff8002,
  0x00000001007f7d02, 0x00000000ffff8003,
  0x00000001007f7d03, 0x00000000ffffff80,
  0x00000001007ffc80, 0x00000000ffffff81,
  0x00000001007ffc81, 0x00000000ffffff82,
  0x00000001007ffc82, 0x00000000ffffff83,
  0x00000001007ffc83, 0x00000000ffffffe0,
  0x00000001007ffce0, 0x00000000fffffffd,
  0x00000000fffffffd, 0x00000000ffffffff,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000000000001,
  0x0000000000000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000021,
  0x0000000000000020, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x0000000033333334,
  0x0000000033333333, 0x0000000055555556,
  0x0000000055555555, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x0000000080000001,
  0x0000000080000000, 0x0000000080000002,
  0x0000000080000001, 0x00000000aaaaaaab,
  0x00000000aaaaaaaa, 0x00000000cccccccd,
  0x00000000cccccccc, 0x00000000ffff8001,
  0x00000000ffff8000, 0x00000000ffff8002,
  0x00000000ffff8001, 0x00000000ffff8003,
  0x00000000ffff8002, 0x00000000ffff8004,
  0x00000000ffff8003, 0x00000000ffffff81,
  0x00000000ffffff80, 0x00000000ffffff82,
  0x00000000ffffff81, 0x00000000ffffff83,
  0x00000000ffffff82, 0x00000000ffffff84,
  0x00000000ffffff83, 0x00000000ffffffe1,
  0x00000000ffffffe0, 0x00000000fffffffe,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000100000001,
  0x0000000100000000, 0x0000000000000002,
  0x0000000000000001, 0x0000000000000003,
  0x0000000000000002, 0x0000000000000004,
  0x0000000000000003, 0x0000000000000022,
  0x0000000000000021, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x0000000000000081,
  0x0000000000000080, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x0000000000008001,
  0x0000000000008000, 0x0000000033333335,
  0x0000000033333334, 0x0000000055555557,
  0x0000000055555556, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x0000000080000001,
  0x0000000080000000, 0x0000000080000002,
  0x0000000080000001, 0x0000000080000003,
  0x0000000080000002, 0x00000000aaaaaaac,
  0x00000000aaaaaaab, 0x00000000ccccccce,
  0x00000000cccccccd, 0x00000000ffff8002,
  0x00000000ffff8001, 0x00000000ffff8003,
  0x00000000ffff8002, 0x00000000ffff8004,
  0x00000000ffff8003, 0x00000000ffff8005,
  0x00000000ffff8004, 0x00000000ffffff82,
  0x00000000ffffff81, 0x00000000ffffff83,
  0x00000000ffffff82, 0x00000000ffffff84,
  0x00000000ffffff83, 0x00000000ffffff85,
  0x00000000ffffff84, 0x00000000ffffffe2,
  0x00000000ffffffe1, 0x00000000ffffffff,
  0x00000000ffffffff, 0x000000010000001e,
  0x0000000100000000, 0x000000010000001f,
  0x0000000100000001, 0x0000000000000020,
  0x0000000000000002, 0x0000000000000021,
  0x0000000000000003, 0x0000000000000022,
  0x0000000000000004, 0x0000000000000040,
  0x0000000000000022, 0x000000000000009d,
  0x000000000000007f, 0x000000000000009e,
  0x0000000000000080, 0x000000000000009f,
  0x0000000000000081, 0x000000000000801d,
  0x0000000000007fff, 0x000000000000801e,
  0x0000000000008000, 0x000000000000801f,
  0x0000000000008001, 0x0000000033333353,
  0x0000000033333335, 0x0000000055555575,
  0x0000000055555557, 0x000000008000001d,
  0x000000007fffffff, 0x000000008000001e,
  0x0000000080000000, 0x000000008000001f,
  0x0000000080000001, 0x0000000080000020,
  0x0000000080000002, 0x0000000080000021,
  0x0000000080000003, 0x00000000aaaaaaca,
  0x00000000aaaaaaac, 0x00000000ccccccec,
  0x00000000ccccccce, 0x00000000ffff8020,
  0x00000000ffff8002, 0x00000000ffff8021,
  0x00000000ffff8003, 0x00000000ffff8022,
  0x00000000ffff8004, 0x00000000ffff8023,
  0x00000000ffff8005, 0x00000000ffffffa0,
  0x00000000ffffff82, 0x00000000ffffffa1,
  0x00000000ffffff83, 0x00000000ffffffa2,
  0x00000000ffffff84, 0x00000000ffffffa3,
  0x00000000ffffff85, 0x0000000100000000,
  0x00000000ffffffe2, 0x000000010000001d,
  0x000000010000001d, 0x000000010000007b,
  0x000000010000001e, 0x000000010000007c,
  0x000000010000001f, 0x000000000000007d,
  0x0000000000000020, 0x000000000000007e,
  0x0000000000000021, 0x000000000000007f,
  0x0000000000000022, 0x000000000000009d,
  0x0000000000000040, 0x00000000000000fa,
  0x000000000000009d, 0x00000000000000fb,
  0x000000000000009e, 0x00000000000000fc,
  0x000000000000009f, 0x000000000000807a,
  0x000000000000801d, 0x000000000000807b,
  0x000000000000801e, 0x000000000000807c,
  0x000000000000801f, 0x00000000333333b0,
  0x0000000033333353, 0x00000000555555d2,
  0x0000000055555575, 0x000000008000007a,
  0x000000008000001d, 0x000000008000007b,
  0x000000008000001e, 0x000000008000007c,
  0x000000008000001f, 0x000000008000007d,
  0x0000000080000020, 0x000000008000007e,
  0x0000000080000021, 0x00000000aaaaab27,
  0x00000000aaaaaaca, 0x00000000cccccd49,
  0x00000000ccccccec, 0x00000000ffff807d,
  0x00000000ffff8020, 0x00000000ffff807e,
  0x00000000ffff8021, 0x00000000ffff807f,
  0x00000000ffff8022, 0x00000000ffff8080,
  0x00000000ffff8023, 0x00000000fffffffd,
  0x00000000ffffffa0, 0x00000000fffffffe,
  0x00000000ffffffa1, 0x00000000ffffffff,
  0x00000000ffffffa2, 0x0000000100000000,
  0x00000000ffffffa3, 0x000000010000005d,
  0x0000000100000000, 0x000000010000007a,
  0x000000010000007a, 0x000000010000007c,
  0x000000010000007b, 0x000000010000007d,
  0x000000010000007c, 0x000000000000007e,
  0x000000000000007d, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x000000000000009e,
  0x000000000000009d, 0x00000000000000fb,
  0x00000000000000fa, 0x00000000000000fc,
  0x00000000000000fb, 0x00000000000000fd,
  0x00000000000000fc, 0x000000000000807b,
  0x000000000000807a, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x00000000333333b1,
  0x00000000333333b0, 0x00000000555555d3,
  0x00000000555555d2, 0x000000008000007b,
  0x000000008000007a, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0x000000008000007e,
  0x000000008000007d, 0x000000008000007f,
  0x000000008000007e, 0x00000000aaaaab28,
  0x00000000aaaaab27, 0x00000000cccccd4a,
  0x00000000cccccd49, 0x00000000ffff807e,
  0x00000000ffff807d, 0x00000000ffff807f,
  0x00000000ffff807e, 0x00000000ffff8080,
  0x00000000ffff807f, 0x00000000ffff8081,
  0x00000000ffff8080, 0x00000000fffffffe,
  0x00000000fffffffd, 0x00000000ffffffff,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000100000001,
  0x0000000100000000, 0x000000010000005e,
  0x000000010000005d, 0x000000010000007b,
  0x000000010000007b, 0x000000010000007d,
  0x000000010000007c, 0x000000010000007e,
  0x000000010000007d, 0x000000000000007f,
  0x000000000000007e, 0x0000000000000080,
  0x000000000000007f, 0x0000000000000081,
  0x0000000000000080, 0x000000000000009f,
  0x000000000000009e, 0x00000000000000fc,
  0x00000000000000fb, 0x00000000000000fd,
  0x00000000000000fc, 0x00000000000000fe,
  0x00000000000000fd, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x000000000000807e,
  0x000000000000807d, 0x00000000333333b2,
  0x00000000333333b1, 0x00000000555555d4,
  0x00000000555555d3, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0x000000008000007e,
  0x000000008000007d, 0x000000008000007f,
  0x000000008000007e, 0x0000000080000080,
  0x000000008000007f, 0x00000000aaaaab29,
  0x00000000aaaaab28, 0x00000000cccccd4b,
  0x00000000cccccd4a, 0x00000000ffff807f,
  0x00000000ffff807e, 0x00000000ffff8080,
  0x00000000ffff807f, 0x00000000ffff8081,
  0x00000000ffff8080, 0x00000000ffff8082,
  0x00000000ffff8081, 0x00000000ffffffff,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000100000001,
  0x0000000100000000, 0x0000000100000002,
  0x0000000100000001, 0x000000010000005f,
  0x000000010000005e, 0x000000010000007c,
  0x000000010000007c, 0x0000000100007ffb,
  0x000000010000007d, 0x0000000100007ffc,
  0x000000010000007e, 0x0000000000007ffd,
  0x000000000000007f, 0x0000000000007ffe,
  0x0000000000000080, 0x0000000000007fff,
  0x0000000000000081, 0x000000000000801d,
  0x000000000000009f, 0x000000000000807a,
  0x00000000000000fc, 0x000000000000807b,
  0x00000000000000fd, 0x000000000000807c,
  0x00000000000000fe, 0x000000000000fffa,
  0x000000000000807c, 0x000000000000fffb,
  0x000000000000807d, 0x000000000000fffc,
  0x000000000000807e, 0x000000003333b330,
  0x00000000333333b2, 0x000000005555d552,
  0x00000000555555d4, 0x0000000080007ffa,
  0x000000008000007c, 0x0000000080007ffb,
  0x000000008000007d, 0x0000000080007ffc,
  0x000000008000007e, 0x0000000080007ffd,
  0x000000008000007f, 0x0000000080007ffe,
  0x0000000080000080, 0x00000000aaab2aa7,
  0x00000000aaaaab29, 0x00000000cccd4cc9,
  0x00000000cccccd4b, 0x00000000fffffffd,
  0x00000000ffff807f, 0x00000000fffffffe,
  0x00000000ffff8080, 0x00000000ffffffff,
  0x00000000ffff8081, 0x0000000100000000,
  0x00000000ffff8082, 0x0000000100007f7d,
  0x00000000ffffffff, 0x0000000100007f7e,
  0x0000000100000000, 0x0000000100007f7f,
  0x0000000100000001, 0x0000000100007f80,
  0x0000000100000002, 0x0000000100007fdd,
  0x000000010000005f, 0x0000000100007ffa,
  0x0000000100007ffa, 0x0000000100007ffc,
  0x0000000100007ffb, 0x0000000100007ffd,
  0x0000000100007ffc, 0x0000000000007ffe,
  0x0000000000007ffd, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x000000000000801e,
  0x000000000000801d, 0x000000000000807b,
  0x000000000000807a, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x000000000000fffb,
  0x000000000000fffa, 0x000000000000fffc,
  0x000000000000fffb, 0x000000000000fffd,
  0x000000000000fffc, 0x000000003333b331,
  0x000000003333b330, 0x000000005555d553,
  0x000000005555d552, 0x0000000080007ffb,
  0x0000000080007ffa, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0x0000000080007ffe,
  0x0000000080007ffd, 0x0000000080007fff,
  0x0000000080007ffe, 0x00000000aaab2aa8,
  0x00000000aaab2aa7, 0x00000000cccd4cca,
  0x00000000cccd4cc9, 0x00000000fffffffe,
  0x00000000fffffffd, 0x00000000ffffffff,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000100000001,
  0x0000000100000000, 0x0000000100007f7e,
  0x0000000100007f7d, 0x0000000100007f7f,
  0x0000000100007f7e, 0x0000000100007f80,
  0x0000000100007f7f, 0x0000000100007f81,
  0x0000000100007f80, 0x0000000100007fde,
  0x0000000100007fdd, 0x0000000100007ffb,
  0x0000000100007ffb, 0x0000000100007ffd,
  0x0000000100007ffc, 0x0000000100007ffe,
  0x0000000100007ffd, 0x0000000000007fff,
  0x0000000000007ffe, 0x0000000000008000,
  0x0000000000007fff, 0x0000000000008001,
  0x0000000000008000, 0x000000000000801f,
  0x000000000000801e, 0x000000000000807c,
  0x000000000000807b, 0x000000000000807d,
  0x000000000000807c, 0x000000000000807e,
  0x000000000000807d, 0x000000000000fffc,
  0x000000000000fffb, 0x000000000000fffd,
  0x000000000000fffc, 0x000000000000fffe,
  0x000000000000fffd, 0x000000003333b332,
  0x000000003333b331, 0x000000005555d554,
  0x000000005555d553, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0x0000000080007ffe,
  0x0000000080007ffd, 0x0000000080007fff,
  0x0000000080007ffe, 0x0000000080008000,
  0x0000000080007fff, 0x00000000aaab2aa9,
  0x00000000aaab2aa8, 0x00000000cccd4ccb,
  0x00000000cccd4cca, 0x00000000ffffffff,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000100000001,
  0x0000000100000000, 0x0000000100000002,
  0x0000000100000001, 0x0000000100007f7f,
  0x0000000100007f7e, 0x0000000100007f80,
  0x0000000100007f7f, 0x0000000100007f81,
  0x0000000100007f80, 0x0000000100007f82,
  0x0000000100007f81, 0x0000000100007fdf,
  0x0000000100007fde, 0x0000000100007ffc,
  0x0000000100007ffc, 0x0000000133333331,
  0x0000000100007ffd, 0x0000000133333332,
  0x0000000100007ffe, 0x0000000033333333,
  0x0000000000007fff, 0x0000000033333334,
  0x0000000000008000, 0x0000000033333335,
  0x0000000000008001, 0x0000000033333353,
  0x000000000000801f, 0x00000000333333b0,
  0x000000000000807c, 0x00000000333333b1,
  0x000000000000807d, 0x00000000333333b2,
  0x000000000000807e, 0x000000003333b330,
  0x000000000000fffc, 0x000000003333b331,
  0x000000000000fffd, 0x000000003333b332,
  0x000000000000fffe, 0x0000000066666666,
  0x000000003333b332, 0x0000000088888888,
  0x000000005555d554, 0x00000000b3333330,
  0x0000000080007ffc, 0x00000000b3333331,
  0x0000000080007ffd, 0x00000000b3333332,
  0x0000000080007ffe, 0x00000000b3333333,
  0x0000000080007fff, 0x00000000b3333334,
  0x0000000080008000, 0x00000000dddddddd,
  0x00000000aaab2aa9, 0x00000000ffffffff,
  0x00000000cccd4ccb, 0x000000013332b333,
  0x00000000ffffffff, 0x000000013332b334,
  0x0000000100000000, 0x000000013332b335,
  0x0000000100000001, 0x000000013332b336,
  0x0000000100000002, 0x00000001333332b3,
  0x0000000100007f7f, 0x00000001333332b4,
  0x0000000100007f80, 0x00000001333332b5,
  0x0000000100007f81, 0x00000001333332b6,
  0x0000000100007f82, 0x0000000133333313,
  0x0000000100007fdf, 0x0000000133333330,
  0x0000000133333330, 0x0000000155555553,
  0x0000000133333331, 0x0000000155555554,
  0x0000000133333332, 0x0000000055555555,
  0x0000000033333333, 0x0000000055555556,
  0x0000000033333334, 0x0000000055555557,
  0x0000000033333335, 0x0000000055555575,
  0x0000000033333353, 0x00000000555555d2,
  0x00000000333333b0, 0x00000000555555d3,
  0x00000000333333b1, 0x00000000555555d4,
  0x00000000333333b2, 0x000000005555d552,
  0x000000003333b330, 0x000000005555d553,
  0x000000003333b331, 0x000000005555d554,
  0x000000003333b332, 0x0000000088888888,
  0x0000000066666666, 0x00000000aaaaaaaa,
  0x0000000088888888, 0x00000000d5555552,
  0x00000000b3333330, 0x00000000d5555553,
  0x00000000b3333331, 0x00000000d5555554,
  0x00000000b3333332, 0x00000000d5555555,
  0x00000000b3333333, 0x00000000d5555556,
  0x00000000b3333334, 0x00000000ffffffff,
  0x00000000dddddddd, 0x0000000122222221,
  0x00000000ffffffff, 0x000000015554d555,
  0x000000013332b333, 0x000000015554d556,
  0x000000013332b334, 0x000000015554d557,
  0x000000013332b335, 0x000000015554d558,
  0x000000013332b336, 0x00000001555554d5,
  0x00000001333332b3, 0x00000001555554d6,
  0x00000001333332b4, 0x00000001555554d7,
  0x00000001333332b5, 0x00000001555554d8,
  0x00000001333332b6, 0x0000000155555535,
  0x0000000133333313, 0x0000000155555552,
  0x0000000155555552, 0x000000017ffffffb,
  0x0000000155555553, 0x000000017ffffffc,
  0x0000000155555554, 0x000000007ffffffd,
  0x0000000055555555, 0x000000007ffffffe,
  0x0000000055555556, 0x000000007fffffff,
  0x0000000055555557, 0x000000008000001d,
  0x0000000055555575, 0x000000008000007a,
  0x00000000555555d2, 0x000000008000007b,
  0x00000000555555d3, 0x000000008000007c,
  0x00000000555555d4, 0x0000000080007ffa,
  0x000000005555d552, 0x0000000080007ffb,
  0x000000005555d553, 0x0000000080007ffc,
  0x000000005555d554, 0x00000000b3333330,
  0x0000000088888888, 0x00000000d5555552,
  0x00000000aaaaaaaa, 0x00000000fffffffa,
  0x00000000d5555552, 0x00000000fffffffb,
  0x00000000d5555553, 0x00000000fffffffc,
  0x00000000d5555554, 0x00000000fffffffd,
  0x00000000d5555555, 0x00000000fffffffe,
  0x00000000d5555556, 0x000000012aaaaaa7,
  0x00000000ffffffff, 0x000000014cccccc9,
  0x0000000122222221, 0x000000017fff7ffd,
  0x000000015554d555, 0x000000017fff7ffe,
  0x000000015554d556, 0x000000017fff7fff,
  0x000000015554d557, 0x000000017fff8000,
  0x000000015554d558, 0x000000017fffff7d,
  0x00000001555554d5, 0x000000017fffff7e,
  0x00000001555554d6, 0x000000017fffff7f,
  0x00000001555554d7, 0x000000017fffff80,
  0x00000001555554d8, 0x000000017fffffdd,
  0x0000000155555535, 0x000000017ffffffa,
  0x000000017ffffffa, 0x000000017ffffffc,
  0x000000017ffffffb, 0x000000017ffffffd,
  0x000000017ffffffc, 0x000000007ffffffe,
  0x000000007ffffffd, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x000000008000001e,
  0x000000008000001d, 0x000000008000007b,
  0x000000008000007a, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0x0000000080007ffb,
  0x0000000080007ffa, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0x00000000b3333331,
  0x00000000b3333330, 0x00000000d5555553,
  0x00000000d5555552, 0x00000000fffffffb,
  0x00000000fffffffa, 0x00000000fffffffc,
  0x00000000fffffffb, 0x00000000fffffffd,
  0x00000000fffffffc, 0x00000000fffffffe,
  0x00000000fffffffd, 0x00000000ffffffff,
  0x00000000fffffffe, 0x000000012aaaaaa8,
  0x000000012aaaaaa7, 0x000000014cccccca,
  0x000000014cccccc9, 0x000000017fff7ffe,
  0x000000017fff7ffd, 0x000000017fff7fff,
  0x000000017fff7ffe, 0x000000017fff8000,
  0x000000017fff7fff, 0x000000017fff8001,
  0x000000017fff8000, 0x000000017fffff7e,
  0x000000017fffff7d, 0x000000017fffff7f,
  0x000000017fffff7e, 0x000000017fffff80,
  0x000000017fffff7f, 0x000000017fffff81,
  0x000000017fffff80, 0x000000017fffffde,
  0x000000017fffffdd, 0x000000017ffffffb,
  0x000000017ffffffb, 0x000000017ffffffd,
  0x000000017ffffffc, 0x000000017ffffffe,
  0x000000017ffffffd, 0x000000007fffffff,
  0x000000007ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x0000000080000001,
  0x0000000080000000, 0x000000008000001f,
  0x000000008000001e, 0x000000008000007c,
  0x000000008000007b, 0x000000008000007d,
  0x000000008000007c, 0x000000008000007e,
  0x000000008000007d, 0x0000000080007ffc,
  0x0000000080007ffb, 0x0000000080007ffd,
  0x0000000080007ffc, 0x0000000080007ffe,
  0x0000000080007ffd, 0x00000000b3333332,
  0x00000000b3333331, 0x00000000d5555554,
  0x00000000d5555553, 0x00000000fffffffc,
  0x00000000fffffffb, 0x00000000fffffffd,
  0x00000000fffffffc, 0x00000000fffffffe,
  0x00000000fffffffd, 0x00000000ffffffff,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x000000012aaaaaa9,
  0x000000012aaaaaa8, 0x000000014ccccccb,
  0x000000014cccccca, 0x000000017fff7fff,
  0x000000017fff7ffe, 0x000000017fff8000,
  0x000000017fff7fff, 0x000000017fff8001,
  0x000000017fff8000, 0x000000017fff8002,
  0x000000017fff8001, 0x000000017fffff7f,
  0x000000017fffff7e, 0x000000017fffff80,
  0x000000017fffff7f, 0x000000017fffff81,
  0x000000017fffff80, 0x000000017fffff82,
  0x000000017fffff81, 0x000000017fffffdf,
  0x000000017fffffde, 0x000000017ffffffc,
  0x000000017ffffffc, 0x000000017ffffffe,
  0x000000017ffffffd, 0x000000017fffffff,
  0x000000017ffffffe, 0x0000000080000000,
  0x000000007fffffff, 0x0000000080000001,
  0x0000000080000000, 0x0000000080000002,
  0x0000000080000001, 0x0000000080000020,
  0x000000008000001f, 0x000000008000007d,
  0x000000008000007c, 0x000000008000007e,
  0x000000008000007d, 0x000000008000007f,
  0x000000008000007e, 0x0000000080007ffd,
  0x0000000080007ffc, 0x0000000080007ffe,
  0x0000000080007ffd, 0x0000000080007fff,
  0x0000000080007ffe, 0x00000000b3333333,
  0x00000000b3333332, 0x00000000d5555555,
  0x00000000d5555554, 0x00000000fffffffd,
  0x00000000fffffffc, 0x00000000fffffffe,
  0x00000000fffffffd, 0x00000000ffffffff,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000100000001,
  0x0000000100000000, 0x000000012aaaaaaa,
  0x000000012aaaaaa9, 0x000000014ccccccc,
  0x000000014ccccccb, 0x000000017fff8000,
  0x000000017fff7fff, 0x000000017fff8001,
  0x000000017fff8000, 0x000000017fff8002,
  0x000000017fff8001, 0x000000017fff8003,
  0x000000017fff8002, 0x000000017fffff80,
  0x000000017fffff7f, 0x000000017fffff81,
  0x000000017fffff80, 0x000000017fffff82,
  0x000000017fffff81, 0x000000017fffff83,
  0x000000017fffff82, 0x000000017fffffe0,
  0x000000017fffffdf, 0x000000017ffffffd,
  0x000000017ffffffd, 0x000000017fffffff,
  0x000000017ffffffe, 0x0000000180000000,
  0x000000017fffffff, 0x0000000080000001,
  0x0000000080000000, 0x0000000080000002,
  0x0000000080000001, 0x0000000080000003,
  0x0000000080000002, 0x0000000080000021,
  0x0000000080000020, 0x000000008000007e,
  0x000000008000007d, 0x000000008000007f,
  0x000000008000007e, 0x0000000080000080,
  0x000000008000007f, 0x0000000080007ffe,
  0x0000000080007ffd, 0x0000000080007fff,
  0x0000000080007ffe, 0x0000000080008000,
  0x0000000080007fff, 0x00000000b3333334,
  0x00000000b3333333, 0x00000000d5555556,
  0x00000000d5555555, 0x00000000fffffffe,
  0x00000000fffffffd, 0x00000000ffffffff,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000100000001,
  0x0000000100000000, 0x0000000100000002,
  0x0000000100000001, 0x000000012aaaaaab,
  0x000000012aaaaaaa, 0x000000014ccccccd,
  0x000000014ccccccc, 0x000000017fff8001,
  0x000000017fff8000, 0x000000017fff8002,
  0x000000017fff8001, 0x000000017fff8003,
  0x000000017fff8002, 0x000000017fff8004,
  0x000000017fff8003, 0x000000017fffff81,
  0x000000017fffff80, 0x000000017fffff82,
  0x000000017fffff81, 0x000000017fffff83,
  0x000000017fffff82, 0x000000017fffff84,
  0x000000017fffff83, 0x000000017fffffe1,
  0x000000017fffffe0, 0x000000017ffffffe,
  0x000000017ffffffe, 0x00000001aaaaaaa8,
  0x000000017fffffff, 0x00000001aaaaaaa9,
  0x0000000180000000, 0x00000000aaaaaaaa,
  0x0000000080000001, 0x00000000aaaaaaab,
  0x0000000080000002, 0x00000000aaaaaaac,
  0x0000000080000003, 0x00000000aaaaaaca,
  0x0000000080000021, 0x00000000aaaaab27,
  0x000000008000007e, 0x00000000aaaaab28,
  0x000000008000007f, 0x00000000aaaaab29,
  0x0000000080000080, 0x00000000aaab2aa7,
  0x0000000080007ffe, 0x00000000aaab2aa8,
  0x0000000080007fff, 0x00000000aaab2aa9,
  0x0000000080008000, 0x00000000dddddddd,
  0x00000000b3333334, 0x00000000ffffffff,
  0x00000000d5555556, 0x000000012aaaaaa7,
  0x00000000fffffffe, 0x000000012aaaaaa8,
  0x00000000ffffffff, 0x000000012aaaaaa9,
  0x0000000100000000, 0x000000012aaaaaaa,
  0x0000000100000001, 0x000000012aaaaaab,
  0x0000000100000002, 0x0000000155555554,
  0x000000012aaaaaab, 0x0000000177777776,
  0x000000014ccccccd, 0x00000001aaaa2aaa,
  0x000000017fff8001, 0x00000001aaaa2aab,
  0x000000017fff8002, 0x00000001aaaa2aac,
  0x000000017fff8003, 0x00000001aaaa2aad,
  0x000000017fff8004, 0x00000001aaaaaa2a,
  0x000000017fffff81, 0x00000001aaaaaa2b,
  0x000000017fffff82, 0x00000001aaaaaa2c,
  0x000000017fffff83, 0x00000001aaaaaa2d,
  0x000000017fffff84, 0x00000001aaaaaa8a,
  0x000000017fffffe1, 0x00000001aaaaaaa7,
  0x00000001aaaaaaa7, 0x00000001ccccccca,
  0x00000001aaaaaaa8, 0x00000001cccccccb,
  0x00000001aaaaaaa9, 0x00000000cccccccc,
  0x00000000aaaaaaaa, 0x00000000cccccccd,
  0x00000000aaaaaaab, 0x00000000ccccccce,
  0x00000000aaaaaaac, 0x00000000ccccccec,
  0x00000000aaaaaaca, 0x00000000cccccd49,
  0x00000000aaaaab27, 0x00000000cccccd4a,
  0x00000000aaaaab28, 0x00000000cccccd4b,
  0x00000000aaaaab29, 0x00000000cccd4cc9,
  0x00000000aaab2aa7, 0x00000000cccd4cca,
  0x00000000aaab2aa8, 0x00000000cccd4ccb,
  0x00000000aaab2aa9, 0x00000000ffffffff,
  0x00000000dddddddd, 0x0000000122222221,
  0x00000000ffffffff, 0x000000014cccccc9,
  0x000000012aaaaaa7, 0x000000014cccccca,
  0x000000012aaaaaa8, 0x000000014ccccccb,
  0x000000012aaaaaa9, 0x000000014ccccccc,
  0x000000012aaaaaaa, 0x000000014ccccccd,
  0x000000012aaaaaab, 0x0000000177777776,
  0x0000000155555554, 0x0000000199999998,
  0x0000000177777776, 0x00000001cccc4ccc,
  0x00000001aaaa2aaa, 0x00000001cccc4ccd,
  0x00000001aaaa2aab, 0x00000001cccc4cce,
  0x00000001aaaa2aac, 0x00000001cccc4ccf,
  0x00000001aaaa2aad, 0x00000001cccccc4c,
  0x00000001aaaaaa2a, 0x00000001cccccc4d,
  0x00000001aaaaaa2b, 0x00000001cccccc4e,
  0x00000001aaaaaa2c, 0x00000001cccccc4f,
  0x00000001aaaaaa2d, 0x00000001ccccccac,
  0x00000001aaaaaa8a, 0x00000001ccccccc9,
  0x00000001ccccccc9, 0x00000001ffff7ffe,
  0x00000001ccccccca, 0x00000001ffff7fff,
  0x00000001cccccccb, 0x00000000ffff8000,
  0x00000000cccccccc, 0x00000000ffff8001,
  0x00000000cccccccd, 0x00000000ffff8002,
  0x00000000ccccccce, 0x00000000ffff8020,
  0x00000000ccccccec, 0x00000000ffff807d,
  0x00000000cccccd49, 0x00000000ffff807e,
  0x00000000cccccd4a, 0x00000000ffff807f,
  0x00000000cccccd4b, 0x00000000fffffffd,
  0x00000000cccd4cc9, 0x00000000fffffffe,
  0x00000000cccd4cca, 0x00000000ffffffff,
  0x00000000cccd4ccb, 0x000000013332b333,
  0x00000000ffffffff, 0x000000015554d555,
  0x0000000122222221, 0x000000017fff7ffd,
  0x000000014cccccc9, 0x000000017fff7ffe,
  0x000000014cccccca, 0x000000017fff7fff,
  0x000000014ccccccb, 0x000000017fff8000,
  0x000000014ccccccc, 0x000000017fff8001,
  0x000000014ccccccd, 0x00000001aaaa2aaa,
  0x0000000177777776, 0x00000001cccc4ccc,
  0x0000000199999998, 0x00000001ffff0000,
  0x00000001cccc4ccc, 0x00000001ffff0001,
  0x00000001cccc4ccd, 0x00000001ffff0002,
  0x00000001cccc4cce, 0x00000001ffff0003,
  0x00000001cccc4ccf, 0x00000001ffff7f80,
  0x00000001cccccc4c, 0x00000001ffff7f81,
  0x00000001cccccc4d, 0x00000001ffff7f82,
  0x00000001cccccc4e, 0x00000001ffff7f83,
  0x00000001cccccc4f, 0x00000001ffff7fe0,
  0x00000001ccccccac, 0x00000001ffff7ffd,
  0x00000001ffff7ffd, 0x00000001ffff7fff,
  0x00000001ffff7ffe, 0x00000001ffff8000,
  0x00000001ffff7fff, 0x00000000ffff8001,
  0x00000000ffff8000, 0x00000000ffff8002,
  0x00000000ffff8001, 0x00000000ffff8003,
  0x00000000ffff8002, 0x00000000ffff8021,
  0x00000000ffff8020, 0x00000000ffff807e,
  0x00000000ffff807d, 0x00000000ffff807f,
  0x00000000ffff807e, 0x00000000ffff8080,
  0x00000000ffff807f, 0x00000000fffffffe,
  0x00000000fffffffd, 0x00000000ffffffff,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x000000013332b334,
  0x000000013332b333, 0x000000015554d556,
  0x000000015554d555, 0x000000017fff7ffe,
  0x000000017fff7ffd, 0x000000017fff7fff,
  0x000000017fff7ffe, 0x000000017fff8000,
  0x000000017fff7fff, 0x000000017fff8001,
  0x000000017fff8000, 0x000000017fff8002,
  0x000000017fff8001, 0x00000001aaaa2aab,
  0x00000001aaaa2aaa, 0x00000001cccc4ccd,
  0x00000001cccc4ccc, 0x00000001ffff0001,
  0x00000001ffff0000, 0x00000001ffff0002,
  0x00000001ffff0001, 0x00000001ffff0003,
  0x00000001ffff0002, 0x00000001ffff0004,
  0x00000001ffff0003, 0x00000001ffff7f81,
  0x00000001ffff7f80, 0x00000001ffff7f82,
  0x00000001ffff7f81, 0x00000001ffff7f83,
  0x00000001ffff7f82, 0x00000001ffff7f84,
  0x00000001ffff7f83, 0x00000001ffff7fe1,
  0x00000001ffff7fe0, 0x00000001ffff7ffe,
  0x00000001ffff7ffe, 0x00000001ffff8000,
  0x00000001ffff7fff, 0x00000001ffff8001,
  0x00000001ffff8000, 0x00000000ffff8002,
  0x00000000ffff8001, 0x00000000ffff8003,
  0x00000000ffff8002, 0x00000000ffff8004,
  0x00000000ffff8003, 0x00000000ffff8022,
  0x00000000ffff8021, 0x00000000ffff807f,
  0x00000000ffff807e, 0x00000000ffff8080,
  0x00000000ffff807f, 0x00000000ffff8081,
  0x00000000ffff8080, 0x00000000ffffffff,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000100000001,
  0x0000000100000000, 0x000000013332b335,
  0x000000013332b334, 0x000000015554d557,
  0x000000015554d556, 0x000000017fff7fff,
  0x000000017fff7ffe, 0x000000017fff8000,
  0x000000017fff7fff, 0x000000017fff8001,
  0x000000017fff8000, 0x000000017fff8002,
  0x000000017fff8001, 0x000000017fff8003,
  0x000000017fff8002, 0x00000001aaaa2aac,
  0x00000001aaaa2aab, 0x00000001cccc4cce,
  0x00000001cccc4ccd, 0x00000001ffff0002,
  0x00000001ffff0001, 0x00000001ffff0003,
  0x00000001ffff0002, 0x00000001ffff0004,
  0x00000001ffff0003, 0x00000001ffff0005,
  0x00000001ffff0004, 0x00000001ffff7f82,
  0x00000001ffff7f81, 0x00000001ffff7f83,
  0x00000001ffff7f82, 0x00000001ffff7f84,
  0x00000001ffff7f83, 0x00000001ffff7f85,
  0x00000001ffff7f84, 0x00000001ffff7fe2,
  0x00000001ffff7fe1, 0x00000001ffff7fff,
  0x00000001ffff7fff, 0x00000001ffff8001,
  0x00000001ffff8000, 0x00000001ffff8002,
  0x00000001ffff8001, 0x00000000ffff8003,
  0x00000000ffff8002, 0x00000000ffff8004,
  0x00000000ffff8003, 0x00000000ffff8005,
  0x00000000ffff8004, 0x00000000ffff8023,
  0x00000000ffff8022, 0x00000000ffff8080,
  0x00000000ffff807f, 0x00000000ffff8081,
  0x00000000ffff8080, 0x00000000ffff8082,
  0x00000000ffff8081, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000100000001,
  0x0000000100000000, 0x0000000100000002,
  0x0000000100000001, 0x000000013332b336,
  0x000000013332b335, 0x000000015554d558,
  0x000000015554d557, 0x000000017fff8000,
  0x000000017fff7fff, 0x000000017fff8001,
  0x000000017fff8000, 0x000000017fff8002,
  0x000000017fff8001, 0x000000017fff8003,
  0x000000017fff8002, 0x000000017fff8004,
  0x000000017fff8003, 0x00000001aaaa2aad,
  0x00000001aaaa2aac, 0x00000001cccc4ccf,
  0x00000001cccc4cce, 0x00000001ffff0003,
  0x00000001ffff0002, 0x00000001ffff0004,
  0x00000001ffff0003, 0x00000001ffff0005,
  0x00000001ffff0004, 0x00000001ffff0006,
  0x00000001ffff0005, 0x00000001ffff7f83,
  0x00000001ffff7f82, 0x00000001ffff7f84,
  0x00000001ffff7f83, 0x00000001ffff7f85,
  0x00000001ffff7f84, 0x00000001ffff7f86,
  0x00000001ffff7f85, 0x00000001ffff7fe3,
  0x00000001ffff7fe2, 0x00000001ffff8000,
  0x00000001ffff8000, 0x00000001ffffff7e,
  0x00000001ffff8001, 0x00000001ffffff7f,
  0x00000001ffff8002, 0x00000000ffffff80,
  0x00000000ffff8003, 0x00000000ffffff81,
  0x00000000ffff8004, 0x00000000ffffff82,
  0x00000000ffff8005, 0x00000000ffffffa0,
  0x00000000ffff8023, 0x00000000fffffffd,
  0x00000000ffff8080, 0x00000000fffffffe,
  0x00000000ffff8081, 0x00000000ffffffff,
  0x00000000ffff8082, 0x0000000100007f7d,
  0x0000000100000000, 0x0000000100007f7e,
  0x0000000100000001, 0x0000000100007f7f,
  0x0000000100000002, 0x00000001333332b3,
  0x000000013332b336, 0x00000001555554d5,
  0x000000015554d558, 0x000000017fffff7d,
  0x000000017fff8000, 0x000000017fffff7e,
  0x000000017fff8001, 0x000000017fffff7f,
  0x000000017fff8002, 0x000000017fffff80,
  0x000000017fff8003, 0x000000017fffff81,
  0x000000017fff8004, 0x00000001aaaaaa2a,
  0x00000001aaaa2aad, 0x00000001cccccc4c,
  0x00000001cccc4ccf, 0x00000001ffff7f80,
  0x00000001ffff0003, 0x00000001ffff7f81,
  0x00000001ffff0004, 0x00000001ffff7f82,
  0x00000001ffff0005, 0x00000001ffff7f83,
  0x00000001ffff0006, 0x00000001ffffff00,
  0x00000001ffff7f83, 0x00000001ffffff01,
  0x00000001ffff7f84, 0x00000001ffffff02,
  0x00000001ffff7f85, 0x00000001ffffff03,
  0x00000001ffff7f86, 0x00000001ffffff60,
  0x00000001ffff7fe3, 0x00000001ffffff7d,
  0x00000001ffffff7d, 0x00000001ffffff7f,
  0x00000001ffffff7e, 0x00000001ffffff80,
  0x00000001ffffff7f, 0x00000000ffffff81,
  0x00000000ffffff80, 0x00000000ffffff82,
  0x00000000ffffff81, 0x00000000ffffff83,
  0x00000000ffffff82, 0x00000000ffffffa1,
  0x00000000ffffffa0, 0x00000000fffffffe,
  0x00000000fffffffd, 0x00000000ffffffff,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000100007f7e,
  0x0000000100007f7d, 0x0000000100007f7f,
  0x0000000100007f7e, 0x0000000100007f80,
  0x0000000100007f7f, 0x00000001333332b4,
  0x00000001333332b3, 0x00000001555554d6,
  0x00000001555554d5, 0x000000017fffff7e,
  0x000000017fffff7d, 0x000000017fffff7f,
  0x000000017fffff7e, 0x000000017fffff80,
  0x000000017fffff7f, 0x000000017fffff81,
  0x000000017fffff80, 0x000000017fffff82,
  0x000000017fffff81, 0x00000001aaaaaa2b,
  0x00000001aaaaaa2a, 0x00000001cccccc4d,
  0x00000001cccccc4c, 0x00000001ffff7f81,
  0x00000001ffff7f80, 0x00000001ffff7f82,
  0x00000001ffff7f81, 0x00000001ffff7f83,
  0x00000001ffff7f82, 0x00000001ffff7f84,
  0x00000001ffff7f83, 0x00000001ffffff01,
  0x00000001ffffff00, 0x00000001ffffff02,
  0x00000001ffffff01, 0x00000001ffffff03,
  0x00000001ffffff02, 0x00000001ffffff04,
  0x00000001ffffff03, 0x00000001ffffff61,
  0x00000001ffffff60, 0x00000001ffffff7e,
  0x00000001ffffff7e, 0x00000001ffffff80,
  0x00000001ffffff7f, 0x00000001ffffff81,
  0x00000001ffffff80, 0x00000000ffffff82,
  0x00000000ffffff81, 0x00000000ffffff83,
  0x00000000ffffff82, 0x00000000ffffff84,
  0x00000000ffffff83, 0x00000000ffffffa2,
  0x00000000ffffffa1, 0x00000000ffffffff,
  0x00000000fffffffe, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000100000001,
  0x0000000100000000, 0x0000000100007f7f,
  0x0000000100007f7e, 0x0000000100007f80,
  0x0000000100007f7f, 0x0000000100007f81,
  0x0000000100007f80, 0x00000001333332b5,
  0x00000001333332b4, 0x00000001555554d7,
  0x00000001555554d6, 0x000000017fffff7f,
  0x000000017fffff7e, 0x000000017fffff80,
  0x000000017fffff7f, 0x000000017fffff81,
  0x000000017fffff80, 0x000000017fffff82,
  0x000000017fffff81, 0x000000017fffff83,
  0x000000017fffff82, 0x00000001aaaaaa2c,
  0x00000001aaaaaa2b, 0x00000001cccccc4e,
  0x00000001cccccc4d, 0x00000001ffff7f82,
  0x00000001ffff7f81, 0x00000001ffff7f83,
  0x00000001ffff7f82, 0x00000001ffff7f84,
  0x00000001ffff7f83, 0x00000001ffff7f85,
  0x00000001ffff7f84, 0x00000001ffffff02,
  0x00000001ffffff01, 0x00000001ffffff03,
  0x00000001ffffff02, 0x00000001ffffff04,
  0x00000001ffffff03, 0x00000001ffffff05,
  0x00000001ffffff04, 0x00000001ffffff62,
  0x00000001ffffff61, 0x00000001ffffff7f,
  0x00000001ffffff7f, 0x00000001ffffff81,
  0x00000001ffffff80, 0x00000001ffffff82,
  0x00000001ffffff81, 0x00000000ffffff83,
  0x00000000ffffff82, 0x00000000ffffff84,
  0x00000000ffffff83, 0x00000000ffffff85,
  0x00000000ffffff84, 0x00000000ffffffa3,
  0x00000000ffffffa2, 0x0000000100000000,
  0x00000000ffffffff, 0x0000000100000001,
  0x0000000100000000, 0x0000000100000002,
  0x0000000100000001, 0x0000000100007f80,
  0x0000000100007f7f, 0x0000000100007f81,
  0x0000000100007f80, 0x0000000100007f82,
  0x0000000100007f81, 0x00000001333332b6,
  0x00000001333332b5, 0x00000001555554d8,
  0x00000001555554d7, 0x000000017fffff80,
  0x000000017fffff7f, 0x000000017fffff81,
  0x000000017fffff80, 0x000000017fffff82,
  0x000000017fffff81, 0x000000017fffff83,
  0x000000017fffff82, 0x000000017fffff84,
  0x000000017fffff83, 0x00000001aaaaaa2d,
  0x00000001aaaaaa2c, 0x00000001cccccc4f,
  0x00000001cccccc4e, 0x00000001ffff7f83,
  0x00000001ffff7f82, 0x00000001ffff7f84,
  0x00000001ffff7f83, 0x00000001ffff7f85,
  0x00000001ffff7f84, 0x00000001ffff7f86,
  0x00000001ffff7f85, 0x00000001ffffff03,
  0x00000001ffffff02, 0x00000001ffffff04,
  0x00000001ffffff03, 0x00000001ffffff05,
  0x00000001ffffff04, 0x00000001ffffff06,
  0x00000001ffffff05, 0x00000001ffffff63,
  0x00000001ffffff62, 0x00000001ffffff80,
  0x00000001ffffff80, 0x00000001ffffffde,
  0x00000001ffffff81, 0x00000001ffffffdf,
  0x00000001ffffff82, 0x00000000ffffffe0,
  0x00000000ffffff83, 0x00000000ffffffe1,
  0x00000000ffffff84, 0x00000000ffffffe2,
  0x00000000ffffff85, 0x0000000100000000,
  0x00000000ffffffa3, 0x000000010000005d,
  0x0000000100000000, 0x000000010000005e,
  0x0000000100000001, 0x000000010000005f,
  0x0000000100000002, 0x0000000100007fdd,
  0x0000000100007f80, 0x0000000100007fde,
  0x0000000100007f81, 0x0000000100007fdf,
  0x0000000100007f82, 0x0000000133333313,
  0x00000001333332b6, 0x0000000155555535,
  0x00000001555554d8, 0x000000017fffffdd,
  0x000000017fffff80, 0x000000017fffffde,
  0x000000017fffff81, 0x000000017fffffdf,
  0x000000017fffff82, 0x000000017fffffe0,
  0x000000017fffff83, 0x000000017fffffe1,
  0x000000017fffff84, 0x00000001aaaaaa8a,
  0x00000001aaaaaa2d, 0x00000001ccccccac,
  0x00000001cccccc4f, 0x00000001ffff7fe0,
  0x00000001ffff7f83, 0x00000001ffff7fe1,
  0x00000001ffff7f84, 0x00000001ffff7fe2,
  0x00000001ffff7f85, 0x00000001ffff7fe3,
  0x00000001ffff7f86, 0x00000001ffffff60,
  0x00000001ffffff03, 0x00000001ffffff61,
  0x00000001ffffff04, 0x00000001ffffff62,
  0x00000001ffffff05, 0x00000001ffffff63,
  0x00000001ffffff06, 0x00000001ffffffc0,
  0x00000001ffffff63, 0x00000001ffffffdd,
  0x00000001ffffffdd, 0x00000001fffffffb,
  0x00000001ffffffde, 0x00000001fffffffc,
  0x00000001ffffffdf, 0x00000000fffffffd,
  0x00000000ffffffe0, 0x00000000fffffffe,
  0x00000000ffffffe1, 0x00000000ffffffff,
  0x00000000ffffffe2, 0x000000010000001d,
  0x0000000100000000, 0x000000010000007a,
  0x000000010000005d, 0x000000010000007b,
  0x000000010000005e, 0x000000010000007c,
  0x000000010000005f, 0x0000000100007ffa,
  0x0000000100007fdd, 0x0000000100007ffb,
  0x0000000100007fde, 0x0000000100007ffc,
  0x0000000100007fdf, 0x0000000133333330,
  0x0000000133333313, 0x0000000155555552,
  0x0000000155555535, 0x000000017ffffffa,
  0x000000017fffffdd, 0x000000017ffffffb,
  0x000000017fffffde, 0x000000017ffffffc,
  0x000000017fffffdf, 0x000000017ffffffd,
  0x000000017fffffe0, 0x000000017ffffffe,
  0x000000017fffffe1, 0x00000001aaaaaaa7,
  0x00000001aaaaaa8a, 0x00000001ccccccc9,
  0x00000001ccccccac, 0x00000001ffff7ffd,
  0x00000001ffff7fe0, 0x00000001ffff7ffe,
  0x00000001ffff7fe1, 0x00000001ffff7fff,
  0x00000001ffff7fe2, 0x00000001ffff8000,
  0x00000001ffff7fe3, 0x00000001ffffff7d,
  0x00000001ffffff60, 0x00000001ffffff7e,
  0x00000001ffffff61, 0x00000001ffffff7f,
  0x00000001ffffff62, 0x00000001ffffff80,
  0x00000001ffffff63, 0x00000001ffffffdd,
  0x00000001ffffffc0, 0x00000001fffffffa,
};
const unsigned kExpectedCount_NEON_uaddl_2D = 961;

#endif  // VIXL_SIM_UADDL_2D_TRACE_AARCH64_H_
