/*-----------------------------------------------------------------------------
  Am.h
  
  (c) Simon Marlow 1990-1993
  (c) Albert Graef 1994

  modified 2005, 2006 by Bernhard R. Link (see Changelog)
-----------------------------------------------------------------------------*/

#ifndef AM_H
#define AM_H

#include "Fm.h"
#include <sys/param.h>

/*--FmAw---------------------------------------------------------------------*/

#define MAXAPPSTRINGLEN MAXPATHLEN

typedef struct {
	char *name;
	char *directory;
	char *icon;
	char *push_action;
	char *drop_action;
	Pixmap icon_bm;
	Widget form, toggle, label;
	Boolean selected;
} AppRec, *AppList;

typedef struct {
	Widget shell, form, viewport, button_box, icon_box;
	AppList apps;
	Cardinal n_apps;
	Cardinal n_selections;
	char *app_file;
	Boolean readonly;
} AppWindowRec;
 
extern AppWindowRec aw;
extern Widget app_popup_widget, *app_popup_items,
              app_popup_widget1, *app_popup_items1;

extern int n_appst;
extern char **appst;

int parseApp(FILE *fp, Boolean loadicons);
void createApplicationWindow(void);
void createApplicationDisplay(void);
void updateApplicationDisplay(void);
void setApplicationWindowName(void);
void readApplicationData(void);
int writeApplicationData(void);
void installApplication(const char *name, const char *directory,
                        const char *icon,
                        const char *push_action, const char *drop_action);
void replaceApplication(AppRec *app, const char *name, const char *directory,
                        const char *icon,
			const char *push_action, const char *drop_action);
void freeApplicationResources(AppRec *app);
void popApplicationsFile(void);
void clearApplicationsStack(void);

void AmReadUpdate(void);
Boolean AmPushLoadFile(const char *filename, Boolean fromFW);
/*--FmAwCb-------------------------------------------------------------------*/

CallbackProc 
  appInstallAppCb, appInstallGroupCb, appEditCb, appCutCb, appCopyCb,
  appPasteCb, appRemoveCb, appSelectAllCb, appDeselectCb, appLoadCb,
  appMainCb, appBackCb, appOpenCb, appCloseCb, aboutCb;

/*--FmAwActions--------------------------------------------------------------*/

int  findAppWidget(Widget w);

FmActionProc appPopup, appMaybeHighlight, runApp, appSelect, appToggle, appTrackCursor;

void appBeginDrag(Widget w, XEvent *event, String *params, 
		  Cardinal *num_params);

void appEndDrag(int i);
void appEndDragInBox(void);

/*--FmAwPopup----------------------------------------------------------------*/

void installNewAppPopup(void);
void installExistingAppPopup(void);
void installGroupPopup(void);
void createInstallPopups(void);

#endif
