/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: xracer.h,v 1.14 2000/03/19 23:48:47 rich Exp $
 */

#ifndef __xracer_h__
#define __xracer_h__

#include <stdlib.h>

#include <GL/gl.h>

/* Variables. */
extern int xrWidth;
extern int xrHeight;
extern int xrFullScreen;
extern int xrMipmapping;
extern int xrHaveIntroSequence;

/* Current time, recalculated once at the beginning of the program and then
 * again at the beginning of each frame.
 */
extern double xrCurrentTime;

/* Time between the current frame and the last frame. */
extern double xrTimeInterval;

/* Fix [v]snprintf for machines which have this missing. */
#ifndef HAVE_VSNPRINTF
#define vsnprintf(s,n,f,a) vsprintf (s,f,a)
#endif

#ifndef HAVE_SNPRINTF
#define snprintf(s,n,f...) sprintf (s,f...)
#endif

/* Memory management wrapper functions. */
extern void *xmalloc (size_t n);
extern void *xrealloc (void *p, size_t n);
extern char *xstrdup (char *p);

/* Some miscellaneous menu and mode initialization functions. */
extern void xrStartMenuInit (void);
extern void xrQuitMenuInit (void);
extern void xrConfigurationMenuInit (void);
extern void xrKeyboardConfigurationMenuInit (void);
extern void xrLoadTrackModeInit (void);
extern void xrIntroModeInit (void);

/* Game modes. */
#define XR_GAME_MODE_TIME_TRIAL   1 /* Implemented. */
#define XR_GAME_MODE_ARCADE       2 /* Not implemented. */
#define XR_GAME_MODE_NETWORK      3 /* Not implemented. */

/* Colours. */
extern const GLfloat xrColour[8][4];
extern const GLfloat *xrColourBlack, *xrColourBlue, *xrColourGreen,
  *xrColourCyan, *xrColourRed, *xrColourMagenta, *xrColourYellow,
  *xrColourWhite;

#endif /* __xracer_h__ */
